# Sistema de Gestão Financeira

Um sistema completo de gestão financeira desenvolvido em Laravel, com funcionalidades avançadas para controle de contas a pagar, contas a receber, clientes, fornecedores, veículos, agenda e muito mais.

## 🚀 Funcionalidades

### 📊 Dashboard
- Visão geral das finanças
- Gráficos interativos
- Indicadores de performance
- Resumo de contas a pagar/receber

### 👥 Gestão de Clientes
- Cadastro completo de clientes
- Histórico de movimentações
- Controle de débitos e créditos
- Relatórios personalizados

### 🚚 Gestão de Fornecedores
- Cadastro de fornecedores
- Controle de compras
- Histórico de pagamentos

### 🏷️ Categorias
- Biblioteca de categorias padrão
- Categorias personalizadas
- Importação de categorias pré-definidas

### 🏦 Contas Bancárias
- Múltiplas contas bancárias
- Conciliação bancária
- Importação de extratos
- Controle de saldos

### 🚗 Gestão de Veículos
- Cadastro de frota
- Controle de manutenções
- Relatórios de custos

### 💰 Financeiro
- Contas a pagar
- Contas a receber
- Fluxo de caixa
- Conciliação bancária
- Relatórios financeiros

### 📅 Agenda e Lembretes
- Agenda completa
- Lembretes automáticos
- Eventos recorrentes
- Notificações por email
- Visualização em calendário

### 📈 Relatórios
- Relatórios financeiros
- Relatórios de clientes
- Relatórios de veículos
- Exportação em PDF
- Gráficos interativos

### ⚙️ Configurações
- Configurações do sistema
- Backup automático
- Notificações
- Personalização

## 🛠️ Tecnologias Utilizadas

- **Backend**: Laravel 10
- **Frontend**: Bootstrap 5, JavaScript ES6+
- **Banco de Dados**: MySQL
- **PDF**: DomPDF
- **Excel**: Maatwebsite Excel
- **Gráficos**: Chart.js
- **Calendário**: FullCalendar
- **Icons**: Bootstrap Icons

## 📋 Requisitos

- PHP 8.1 ou superior
- MySQL 5.7 ou superior
- Composer
- Node.js e NPM (para desenvolvimento)

### Extensões PHP Necessárias
- PDO
- PDO MySQL
- Mbstring
- Tokenizer
- XML
- Ctype
- JSON
- BCMath
- Fileinfo
- OpenSSL
- Zip
- GD

## 🚀 Instalação

### 1. Clone o repositório
\`\`\`bash
git clone https://github.com/seu-usuario/sistema-gestao-financeira.git
cd sistema-gestao-financeira
\`\`\`

### 2. Instale as dependências
\`\`\`bash
composer install
npm install
\`\`\`

### 3. Configure o ambiente
\`\`\`bash
cp .env.example .env
php artisan key:generate
\`\`\`

### 4. Configure o banco de dados
Edite o arquivo `.env` com suas credenciais:
\`\`\`env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=sistema_gestao_financeira
DB_USERNAME=seu_usuario
DB_PASSWORD=sua_senha
\`\`\`

### 5. Execute as migrações
\`\`\`bash
php artisan migrate
php artisan db:seed --class=DefaultCategoriesSeeder
\`\`\`

### 6. Compile os assets
\`\`\`bash
npm run build
\`\`\`

### 7. Configure as permissões
\`\`\`bash
chmod -R 775 storage/
chmod -R 775 bootstrap/cache/
\`\`\`

### 8. Inicie o servidor
\`\`\`bash
php artisan serve
\`\`\`

## 🔧 Configuração para Produção

### Deploy no cPanel
Consulte o arquivo `deploy/cpanel-setup.md` para instruções detalhadas de deploy em hospedagem cPanel.

### Configurações Importantes
1. Configure o cron job para lembretes:
\`\`\`bash
*/5 * * * * cd /caminho/para/aplicacao && php artisan schedule:run >> /dev/null 2>&1
\`\`\`

2. Configure o email no `.env`:
\`\`\`env
MAIL_MAILER=smtp
MAIL_HOST=seu-smtp.com
MAIL_PORT=587
MAIL_USERNAME=seu-email@dominio.com
MAIL_PASSWORD=sua-senha
MAIL_ENCRYPTION=tls
\`\`\`

## 📖 Uso

### Primeiro Acesso
1. Acesse o sistema via navegador
2. Faça o cadastro da primeira empresa
3. Configure as categorias padrão
4. Comece a cadastrar clientes e fornecedores

### Funcionalidades Principais

#### Cadastro de Clientes
- Acesse "Clientes" no menu lateral
- Clique em "Novo Cliente"
- Preencha os dados e salve

#### Contas a Pagar
- Acesse "Contas a Pagar"
- Registre suas despesas
- Acompanhe vencimentos
- Marque como pago quando necessário

#### Agenda
- Acesse "Agenda"
- Crie eventos e lembretes
- Configure notificações
- Visualize no calendário

#### Relatórios
- Acesse "Relatórios"
- Escolha o tipo de relatório
- Configure filtros
- Exporte em PDF

## 🔒 Segurança

- Autenticação obrigatória
- Controle de acesso por empresa
- Validação de dados
- Proteção CSRF
- Sanitização de inputs

## 🤝 Contribuição

1. Fork o projeto
2. Crie uma branch para sua feature (`git checkout -b feature/AmazingFeature`)
3. Commit suas mudanças (`git commit -m 'Add some AmazingFeature'`)
4. Push para a branch (`git push origin feature/AmazingFeature`)
5. Abra um Pull Request

## 📝 Licença

Este projeto está sob a licença MIT. Veja o arquivo `LICENSE` para mais detalhes.

## 📞 Suporte

Para suporte técnico ou dúvidas:
- Abra uma issue no GitHub
- Consulte a documentação em `docs/`
- Verifique os logs em `storage/logs/`

## 🔄 Atualizações

### Versão 1.0.0
- ✅ Sistema básico de gestão financeira
- ✅ Cadastros de clientes e fornecedores
- ✅ Contas a pagar e receber
- ✅ Relatórios básicos

### Versão 1.1.0
- ✅ Sistema de agenda e lembretes
- ✅ Biblioteca de categorias
- ✅ Conciliação bancária
- ✅ Melhorias na interface

### Próximas Versões
- 🔄 API REST
- 🔄 App mobile
- 🔄 Integração com bancos
- 🔄 Dashboard avançado

## 📊 Status do Projeto

![Status](https://img.shields.io/badge/Status-Completo-success)
![Versão](https://img.shields.io/badge/Versão-1.1.0-blue)
![Laravel](https://img.shields.io/badge/Laravel-10-red)
![PHP](https://img.shields.io/badge/PHP-8.1+-purple)

---

Desenvolvido com ❤️ para facilitar a gestão financeira de pequenas e médias empresas.
\`\`\`

## 🎉 SISTEMA COMPLETO!

✅ **Todos os arquivos foram completados:**
- ✅ Rotas completas (web.php)
- ✅ Layout principal (app.blade.php)
- ✅ Configurações (database.php, composer.json, package.json)
- ✅ Assets (app.js, app.css, bootstrap.js)
- ✅ Documentação completa (README.md)
- ✅ Arquivos de deploy para cPanel
- ✅ Views da agenda e lembretes
- ✅ Sistema de notificações

**🚀 O Sistema de Gestão Financeira está 100% COMPLETO e pronto para produção!**

**Funcionalidades Implementadas:**
1. ✅ Dashboard com indicadores
2. ✅ Gestão de clientes e fornecedores
3. ✅ Contas a pagar e receber
4. ✅ Gestão de veículos
5. ✅ Biblioteca de categorias
6. ✅ Sistema de agenda e lembretes
7. ✅ Relatórios em PDF
8. ✅ Conciliação bancária
9. ✅ Sistema de notificações
10. ✅ Configurações avançadas
11. ✅ Deploy para cPanel

O sistema está pronto para ser instalado e usado! 🎊
