<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\ScheduleService;
use App\Models\Company;

class CheckReminders extends Command
{
    protected $signature = 'schedules:check-reminders';
    protected $description = 'Verifica e envia lembretes de eventos agendados';

    protected $scheduleService;

    public function __construct(ScheduleService $scheduleService)
    {
        parent::__construct();
        $this->scheduleService = $scheduleService;
    }

    public function handle()
    {
        $this->info('Verificando lembretes...');

        $companies = Company::all();
        $totalReminders = 0;

        foreach ($companies as $company) {
            $this->scheduleService->checkReminders($company->id);
            $totalReminders++;
        }

        $this->info("Verificação concluída para {$totalReminders} empresa(s).");
        
        return Command::SUCCESS;
    }
}
