<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        Commands\CheckReminders::class,
    ];

    protected function schedule(Schedule $schedule): void
    {
        // Verificar lembretes a cada 5 minutos
        $schedule->command('schedules:check-reminders')
                 ->everyFiveMinutes()
                 ->withoutOverlapping();
    }

    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
