<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureUserBelongsToCompany
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        // Adiciona o company_id automaticamente em todas as queries
        $user = Auth::user();
        
        // Define o company_id global para todas as queries
        app()->instance('current_company_id', $user->company_id);
        
        return $next($request);
    }
}
