<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CarRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'model' => 'required|string|max:255',
            'brand' => 'required|string|max:255',
            'year' => 'nullable|integer|min:1900|max:' . (date('Y') + 1),
            'plate' => 'nullable|string|max:10',
            'color' => 'nullable|string|max:50',
            'purchase_price' => 'nullable|numeric|min:0',
            'purchase_date' => 'nullable|date',
            'notes' => 'nullable|string|max:1000',
            'photos.*' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ];
    }

    public function messages(): array
    {
        return [
            'model.required' => 'O modelo é obrigatório.',
            'brand.required' => 'A marca é obrigatória.',
            'year.integer' => 'O ano deve ser um número.',
            'year.min' => 'Ano inválido.',
            'year.max' => 'Ano inválido.',
            'purchase_price.numeric' => 'O preço deve ser um número.',
            'photos.*.image' => 'Apenas imagens são permitidas.',
            'photos.*.max' => 'Cada imagem deve ter no máximo 2MB.',
        ];
    }
}
