<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CategoryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $categoryId = $this->route('category')?->id;

        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('categories')
                    ->where('company_id', auth()->user()->company_id)
                    ->ignore($categoryId)
            ],
            'description' => 'nullable|string|max:1000',
            'type' => 'required|in:income,expense',
            'color' => 'required|string|regex:/^#[0-9A-Fa-f]{6}$/',
            'icon' => 'required|string|max:50',
            'keywords_string' => 'nullable|string|max:500',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'O nome da categoria é obrigatório.',
            'name.unique' => 'Já existe uma categoria com este nome.',
            'type.required' => 'O tipo da categoria é obrigatório.',
            'type.in' => 'O tipo deve ser Receita ou Despesa.',
            'color.required' => 'A cor da categoria é obrigatória.',
            'color.regex' => 'A cor deve estar no formato hexadecimal (#RRGGBB).',
            'icon.required' => 'O ícone da categoria é obrigatório.',
        ];
    }
}
