<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BankReconciliation extends Model
{
    use HasFactory;

    protected $table = 'bank_reconciliation';

    protected $fillable = [
        'transaction_date',
        'description',
        'document_number',
        'amount',
        'type',
        'status',
        'bank_reference',
        'bank_account_id',
        'account_payable_id',
        'account_receivable_id',
        'category_id',
        'notes',
        'import_file',
        'company_id',
    ];

    protected $casts = [
        'transaction_date' => 'date',
        'amount' => 'decimal:2',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function bankAccount(): BelongsTo
    {
        return $this->belongsTo(BankAccount::class);
    }

    public function accountPayable(): BelongsTo
    {
        return $this->belongsTo(AccountPayable::class);
    }

    public function accountReceivable(): BelongsTo
    {
        return $this->belongsTo(AccountReceivable::class);
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function getStatusBadgeAttribute(): string
    {
        return match($this->status) {
            'pending' => '<span class="badge bg-warning">Pendente</span>',
            'reconciled' => '<span class="badge bg-success">Conciliado</span>',
            'ignored' => '<span class="badge bg-secondary">Ignorado</span>',
            default => '<span class="badge bg-light">Indefinido</span>',
        };
    }

    public function getTypeBadgeAttribute(): string
    {
        return match($this->type) {
            'credit' => '<span class="badge bg-success">Crédito</span>',
            'debit' => '<span class="badge bg-danger">Débito</span>',
            default => '<span class="badge bg-light">Indefinido</span>',
        };
    }
}
