<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'type',
        'color',
        'default_category_id',
        'keywords',
        'icon',
        'company_id',
    ];

    protected $casts = [
        'keywords' => 'array',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function defaultCategory(): BelongsTo
    {
        return $this->belongsTo(DefaultCategory::class);
    }

    public function accountsPayable(): HasMany
    {
        return $this->hasMany(AccountPayable::class);
    }

    public function accountsReceivable(): HasMany
    {
        return $this->hasMany(AccountReceivable::class);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('type', $type);
    }

    public function scopeForCompany($query, $companyId)
    {
        return $query->where('company_id', $companyId);
    }

    public function getKeywordsStringAttribute(): string
    {
        return is_array($this->keywords) ? implode(', ', $this->keywords) : '';
    }

    public function getUsageCountAttribute(): int
    {
        return $this->accountsPayable()->count() + $this->accountsReceivable()->count();
    }
}
