<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CreditCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'last_four',
        'brand',
        'credit_limit',
        'closing_day',
        'due_day',
        'active',
        'company_id',
    ];

    protected $casts = [
        'credit_limit' => 'decimal:2',
        'active' => 'boolean',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function getMaskedNumberAttribute(): string
    {
        return '**** **** **** ' . $this->last_four;
    }
}
