<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'cpf_cnpj',
        'address',
        'credit_limit',
        'current_balance',
        'active',
        'company_id',
    ];

    protected $casts = [
        'credit_limit' => 'decimal:2',
        'current_balance' => 'decimal:2',
        'active' => 'boolean',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function entries(): HasMany
    {
        return $this->hasMany(CustomerEntry::class);
    }

    public function accountsReceivable(): HasMany
    {
        return $this->hasMany(AccountReceivable::class);
    }

    public function getBalanceAttribute(): float
    {
        $credits = $this->entries()->where('type', 'credit')->sum('amount');
        $debits = $this->entries()->where('type', 'debit')->sum('amount');
        
        return $credits - $debits;
    }

    public function updateBalance(): void
    {
        $this->current_balance = $this->getBalanceAttribute();
        $this->save();
    }
}
