<?php

namespace App\Policies;

use App\Models\AccountPayable;
use App\Models\User;

class AccountPayablePolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, AccountPayable $accountPayable): bool
    {
        return $user->company_id === $accountPayable->company_id;
    }

    public function create(User $user): bool
    {
        return in_array($user->role, ['admin', 'manager']);
    }

    public function update(User $user, AccountPayable $accountPayable): bool
    {
        return $user->company_id === $accountPayable->company_id && 
               in_array($user->role, ['admin', 'manager']);
    }

    public function delete(User $user, AccountPayable $accountPayable): bool
    {
        return $user->company_id === $accountPayable->company_id && 
               $user->role === 'admin';
    }
}
