<?php

namespace App\Policies;

use App\Models\Schedule;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SchedulePolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Schedule $schedule): bool
    {
        return $user->company_id === $schedule->company_id;
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, Schedule $schedule): bool
    {
        return $user->company_id === $schedule->company_id && 
               ($user->id === $schedule->user_id || $user->hasRole('admin'));
    }

    public function delete(User $user, Schedule $schedule): bool
    {
        return $user->company_id === $schedule->company_id && 
               ($user->id === $schedule->user_id || $user->hasRole('admin'));
    }

    public function restore(User $user, Schedule $schedule): bool
    {
        return $this->delete($user, $schedule);
    }

    public function forceDelete(User $user, Schedule $schedule): bool
    {
        return $this->delete($user, $schedule);
    }
}
