<?php

namespace App\Providers;

use App\Models\Customer;
use App\Models\AccountPayable;
use App\Models\AccountReceivable;
use App\Models\Car;
use App\Policies\CustomerPolicy;
use App\Policies\AccountPayablePolicy;
use App\Policies\AccountReceivablePolicy;
use App\Policies\CarPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        Customer::class => CustomerPolicy::class,
        AccountPayable::class => AccountPayablePolicy::class,
        AccountReceivable::class => AccountReceivablePolicy::class,
        Car::class => CarPolicy::class,
    ];

    public function boot(): void
    {
        $this->registerPolicies();
    }
}
