"use client"
import Link from "next/link"
import { usePathname } from "next/navigation"
import { Building2, Users, Car, Banknote, Calendar, BarChart3, Settings, ChevronDown, Home } from "lucide-react"

import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarHeader,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
  SidebarMenuSub,
  SidebarMenuSubButton,
  SidebarMenuSubItem,
} from "@/components/ui/sidebar"
import { Collapsible, CollapsibleContent, CollapsibleTrigger } from "@/components/ui/collapsible"

const menuItems = [
  {
    title: "Dashboard",
    icon: Home,
    href: "/dashboard",
  },
  {
    title: "Financeiro",
    icon: Banknote,
    items: [
      { title: "Contas a Pagar", href: "/financeiro/contas-pagar" },
      { title: "Contas a Receber", href: "/financeiro/contas-receber" },
      { title: "Conciliação Bancária", href: "/financeiro/conciliacao" },
      { title: "Fluxo de Caixa", href: "/financeiro/fluxo-caixa" },
    ],
  },
  {
    title: "Cadastros",
    icon: Users,
    items: [
      { title: "Clientes", href: "/cadastros/clientes" },
      { title: "Fornecedores", href: "/cadastros/fornecedores" },
      { title: "Categorias", href: "/cadastros/categorias" },
      { title: "Contas Bancárias", href: "/cadastros/contas-bancarias" },
      { title: "Cartões de Crédito", href: "/cadastros/cartoes" },
    ],
  },
  {
    title: "Veículos",
    icon: Car,
    items: [
      { title: "Carros", href: "/veiculos/carros" },
      { title: "Despesas", href: "/veiculos/despesas" },
      { title: "Relatório de Lucro", href: "/veiculos/relatorio-lucro" },
    ],
  },
  {
    title: "Agenda",
    icon: Calendar,
    href: "/agenda",
  },
  {
    title: "Relatórios",
    icon: BarChart3,
    items: [
      { title: "Financeiro", href: "/relatorios/financeiro" },
      { title: "Clientes", href: "/relatorios/clientes" },
      { title: "Fornecedores", href: "/relatorios/fornecedores" },
      { title: "Veículos", href: "/relatorios/veiculos" },
    ],
  },
  {
    title: "Configurações",
    icon: Settings,
    href: "/configuracoes",
  },
]

export function AppSidebar() {
  const pathname = usePathname()

  return (
    <Sidebar>
      <SidebarHeader>
        <div className="flex items-center gap-2 px-4 py-2">
          <Building2 className="h-6 w-6" />
          <span className="font-semibold">Sistema Gestão</span>
        </div>
      </SidebarHeader>
      <SidebarContent>
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              {menuItems.map((item) => (
                <SidebarMenuItem key={item.title}>
                  {item.items ? (
                    <Collapsible defaultOpen className="group/collapsible">
                      <CollapsibleTrigger asChild>
                        <SidebarMenuButton>
                          <item.icon className="h-4 w-4" />
                          <span>{item.title}</span>
                          <ChevronDown className="ml-auto h-4 w-4 transition-transform group-data-[state=open]/collapsible:rotate-180" />
                        </SidebarMenuButton>
                      </CollapsibleTrigger>
                      <CollapsibleContent>
                        <SidebarMenuSub>
                          {item.items.map((subItem) => (
                            <SidebarMenuSubItem key={subItem.href}>
                              <SidebarMenuSubButton asChild isActive={pathname === subItem.href}>
                                <Link href={subItem.href}>{subItem.title}</Link>
                              </SidebarMenuSubButton>
                            </SidebarMenuSubItem>
                          ))}
                        </SidebarMenuSub>
                      </CollapsibleContent>
                    </Collapsible>
                  ) : (
                    <SidebarMenuButton asChild isActive={pathname === item.href}>
                      <Link href={item.href!}>
                        <item.icon className="h-4 w-4" />
                        <span>{item.title}</span>
                      </Link>
                    </SidebarMenuButton>
                  )}
                </SidebarMenuItem>
              ))}
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>
      </SidebarContent>
    </Sidebar>
  )
}
