<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', ['debit', 'credit']);
            $table->string('color', 7)->default('#6366f1');
            $table->text('description')->nullable();
            $table->boolean('active')->default(true);
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['company_id', 'type', 'active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
