<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->string('model');
            $table->string('brand');
            $table->integer('year')->nullable();
            $table->string('plate')->nullable();
            $table->string('color')->nullable();
            $table->decimal('purchase_price', 15, 2)->nullable();
            $table->date('purchase_date')->nullable();
            $table->decimal('sale_price', 15, 2)->nullable();
            $table->date('sale_date')->nullable();
            $table->enum('status', ['owned', 'sold', 'maintenance'])->default('owned');
            $table->text('notes')->nullable();
            $table->json('photos')->nullable();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['company_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cars');
    }
};
