<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bank_reconciliation', function (Blueprint $table) {
            $table->id();
            $table->date('transaction_date');
            $table->string('description');
            $table->string('document_number')->nullable();
            $table->decimal('amount', 15, 2);
            $table->enum('type', ['debit', 'credit']);
            $table->enum('status', ['pending', 'reconciled', 'ignored'])->default('pending');
            $table->string('bank_reference')->nullable();
            $table->foreignId('bank_account_id')->constrained()->onDelete('cascade');
            $table->foreignId('account_payable_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('account_receivable_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');
            $table->text('notes')->nullable();
            $table->string('import_file')->nullable();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['company_id', 'bank_account_id', 'status']);
            $table->index(['transaction_date', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bank_reconciliation');
    }
};
