<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('credit_cards', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('last_four', 4);
            $table->string('brand'); // Visa, Mastercard, etc
            $table->decimal('credit_limit', 15, 2)->nullable();
            $table->integer('closing_day')->default(1); // Dia do fechamento
            $table->integer('due_day')->default(10); // Dia do vencimento
            $table->boolean('active')->default(true);
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['company_id', 'active']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('credit_cards');
    }
};
