<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, boolean, integer, json
            $table->string('group')->default('general'); // general, financial, notifications, etc
            $table->string('label');
            $table->text('description')->nullable();
            $table->json('options')->nullable(); // Para selects, checkboxes, etc
            $table->boolean('is_public')->default(false); // Se pode ser acessado sem autenticação
            $table->foreignId('company_id')->nullable()->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['company_id', 'group']);
            $table->index(['key', 'company_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
