<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('message');
            $table->enum('type', ['info', 'warning', 'error', 'success'])->default('info');
            $table->enum('priority', ['low', 'medium', 'high', 'urgent'])->default('medium');
            $table->json('data')->nullable(); // Dados adicionais
            $table->timestamp('scheduled_for')->nullable(); // Para notificações agendadas
            $table->timestamp('read_at')->nullable();
            $table->boolean('is_system')->default(false); // Notificação do sistema
            $table->string('action_url')->nullable(); // URL para ação
            $table->string('action_text')->nullable(); // Texto do botão de ação
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['user_id', 'read_at']);
            $table->index(['company_id', 'type', 'priority']);
            $table->index(['scheduled_for', 'read_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
