<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->unsignedBigInteger('default_category_id')->nullable()->after('color');
            $table->json('keywords')->nullable()->after('default_category_id');
            $table->string('icon')->default('bi-tag')->after('keywords');
            
            $table->foreign('default_category_id')->references('id')->on('default_categories')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropForeign(['default_category_id']);
            $table->dropColumn(['default_category_id', 'keywords', 'icon']);
        });
    }
};
