<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DefaultCategory;

class DefaultCategoriesSeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            // DESPESAS - AUTOMOTIVO
            [
                'name' => 'Combustível',
                'description' => 'Gastos com gasolina, álcool, diesel e outros combustíveis',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-fuel-pump',
                'color' => '#dc3545',
                'keywords' => ['gasolina', 'álcool', 'diesel', 'posto', 'abastecimento'],
                'is_popular' => true,
            ],
            [
                'name' => 'Manutenção Veicular',
                'description' => 'Reparos, revisões e manutenção de veículos',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-tools',
                'color' => '#fd7e14',
                'keywords' => ['mecânico', 'revisão', 'reparo', 'oficina', 'peças'],
                'is_popular' => true,
            ],
            [
                'name' => 'Seguro Veicular',
                'description' => 'Seguros de automóveis, motos e outros veículos',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-shield-check',
                'color' => '#0d6efd',
                'keywords' => ['seguro', 'proteção', 'cobertura', 'sinistro'],
                'is_popular' => true,
            ],
            [
                'name' => 'IPVA',
                'description' => 'Imposto sobre Propriedade de Veículos Automotores',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-file-text',
                'color' => '#6f42c1',
                'keywords' => ['imposto', 'veicular', 'anual', 'governo'],
            ],
            [
                'name' => 'Licenciamento',
                'description' => 'Taxas de licenciamento e documentação veicular',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-card-text',
                'color' => '#20c997',
                'keywords' => ['licença', 'documentação', 'detran', 'renovação'],
            ],
            [
                'name' => 'Multas de Trânsito',
                'description' => 'Multas e infrações de trânsito',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-exclamation-triangle',
                'color' => '#dc3545',
                'keywords' => ['multa', 'infração', 'trânsito', 'velocidade'],
            ],
            [
                'name' => 'Estacionamento',
                'description' => 'Gastos com estacionamento e zona azul',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-p-square',
                'color' => '#6c757d',
                'keywords' => ['parking', 'zona azul', 'vaga', 'rotativo'],
            ],
            [
                'name' => 'Lavagem e Estética',
                'description' => 'Lavagem, enceramento e cuidados estéticos do veículo',
                'type' => 'expense',
                'group' => 'Automotivo',
                'icon' => 'bi-droplet',
                'color' => '#0dcaf0',
                'keywords' => ['lavagem', 'cera', 'limpeza', 'estética'],
            ],

            // DESPESAS - ESCRITÓRIO
            [
                'name' => 'Material de Escritório',
                'description' => 'Papelaria, suprimentos e materiais de escritório',
                'type' => 'expense',
                'group' => 'Escritório',
                'icon' => 'bi-pencil',
                'color' => '#198754',
                'keywords' => ['papel', 'caneta', 'grampeador', 'papelaria'],
                'is_popular' => true,
            ],
            [
                'name' => 'Software e Licenças',
                'description' => 'Licenças de software, aplicativos e sistemas',
                'type' => 'expense',
                'group' => 'Escritório',
                'icon' => 'bi-laptop',
                'color' => '#0d6efd',
                'keywords' => ['software', 'licença', 'aplicativo', 'sistema'],
                'is_popular' => true,
            ],
            [
                'name' => 'Internet e Telefone',
                'description' => 'Serviços de internet, telefone fixo e móvel',
                'type' => 'expense',
                'group' => 'Escritório',
                'icon' => 'bi-wifi',
                'color' => '#6f42c1',
                'keywords' => ['internet', 'telefone', 'banda larga', 'celular'],
                'is_popular' => true,
            ],
            [
                'name' => 'Equipamentos de TI',
                'description' => 'Computadores, impressoras e equipamentos de informática',
                'type' => 'expense',
                'group' => 'Escritório',
                'icon' => 'bi-pc-display',
                'color' => '#495057',
                'keywords' => ['computador', 'impressora', 'monitor', 'hardware'],
            ],
            [
                'name' => 'Móveis e Decoração',
                'description' => 'Móveis, decoração e utensílios para escritório',
                'type' => 'expense',
                'group' => 'Escritório',
                'icon' => 'bi-house',
                'color' => '#795548',
                'keywords' => ['móveis', 'mesa', 'cadeira', 'decoração'],
            ],
            [
                'name' => 'Energia Elétrica',
                'description' => 'Conta de luz e energia elétrica',
                'type' => 'expense',
                'group' => 'Escritório',
                'icon' => 'bi-lightning',
                'color' => '#ffc107',
                'keywords' => ['luz', 'energia', 'eletricidade', 'conta'],
            ],

            // DESPESAS - FINANCEIRO
            [
                'name' => 'Taxas Bancárias',
                'description' => 'Tarifas e taxas cobradas pelos bancos',
                'type' => 'expense',
                'group' => 'Financeiro',
                'icon' => 'bi-bank',
                'color' => '#dc3545',
                'keywords' => ['banco', 'tarifa', 'taxa', 'manutenção'],
                'is_popular' => true,
            ],
            [
                'name' => 'Juros e Multas',
                'description' => 'Juros de financiamentos, empréstimos e multas por atraso',
                'type' => 'expense',
                'group' => 'Financeiro',
                'icon' => 'bi-percent',
                'color' => '#dc3545',
                'keywords' => ['juros', 'multa', 'atraso', 'financiamento', 'empréstimo'],
            ],
            [
                'name' => 'Contabilidade',
                'description' => 'Serviços contábeis e consultoria fiscal',
                'type' => 'expense',
                'group' => 'Financeiro',
                'icon' => 'bi-calculator',
                'color' => '#198754',
                'keywords' => ['contador', 'contabilidade', 'fiscal', 'imposto'],
                'is_popular' => true,
            ],
            [
                'name' => 'Seguros Diversos',
                'description' => 'Seguros de vida, saúde, empresarial e outros',
                'type' => 'expense',
                'group' => 'Financeiro',
                'icon' => 'bi-shield',
                'color' => '#0d6efd',
                'keywords' => ['seguro', 'vida', 'saúde', 'empresarial'],
            ],

            // DESPESAS - MARKETING
            [
                'name' => 'Publicidade Online',
                'description' => 'Anúncios no Google, Facebook, Instagram e outras plataformas',
                'type' => 'expense',
                'group' => 'Marketing',
                'icon' => 'bi-megaphone',
                'color' => '#e91e63',
                'keywords' => ['google ads', 'facebook', 'instagram', 'publicidade'],
                'is_popular' => true,
            ],
            [
                'name' => 'Material Gráfico',
                'description' => 'Cartões de visita, panfletos, banners e materiais impressos',
                'type' => 'expense',
                'group' => 'Marketing',
                'icon' => 'bi-printer',
                'color' => '#ff9800',
                'keywords' => ['cartão', 'panfleto', 'banner', 'gráfica'],
            ],
            [
                'name' => 'Site e Hospedagem',
                'description' => 'Desenvolvimento, manutenção e hospedagem de websites',
                'type' => 'expense',
                'group' => 'Marketing',
                'icon' => 'bi-globe',
                'color' => '#2196f3',
                'keywords' => ['site', 'hospedagem', 'domínio', 'web'],
            ],
            [
                'name' => 'Redes Sociais',
                'description' => 'Ferramentas e serviços para gestão de redes sociais',
                'type' => 'expense',
                'group' => 'Marketing',
                'icon' => 'bi-share',
                'color' => '#9c27b0',
                'keywords' => ['social media', 'instagram', 'facebook', 'twitter'],
            ],

            // DESPESAS - OPERACIONAL
            [
                'name' => 'Aluguel',
                'description' => 'Aluguel de imóveis, escritórios e espaços comerciais',
                'type' => 'expense',
                'group' => 'Operacional',
                'icon' => 'bi-building',
                'color' => '#795548',
                'keywords' => ['aluguel', 'imóvel', 'escritório', 'comercial'],
                'is_popular' => true,
            ],
            [
                'name' => 'Água e Esgoto',
                'description' => 'Conta de água e serviços de saneamento',
                'type' => 'expense',
                'group' => 'Operacional',
                'icon' => 'bi-droplet-fill',
                'color' => '#00bcd4',
                'keywords' => ['água', 'esgoto', 'saneamento', 'conta'],
            ],
            [
                'name' => 'Limpeza e Conservação',
                'description' => 'Produtos de limpeza e serviços de conservação',
                'type' => 'expense',
                'group' => 'Operacional',
                'icon' => 'bi-brush',
                'color' => '#4caf50',
                'keywords' => ['limpeza', 'conservação', 'faxina', 'produtos'],
            ],
            [
                'name' => 'Segurança',
                'description' => 'Sistemas de segurança, alarmes e monitoramento',
                'type' => 'expense',
                'group' => 'Operacional',
                'icon' => 'bi-shield-lock',
                'color' => '#f44336',
                'keywords' => ['segurança', 'alarme', 'monitoramento', 'câmera'],
            ],

            // RECEITAS - VENDAS
            [
                'name' => 'Venda de Veículos',
                'description' => 'Receita proveniente da venda de automóveis',
                'type' => 'income',
                'group' => 'Vendas',
                'icon' => 'bi-car-front',
                'color' => '#28a745',
                'keywords' => ['venda', 'carro', 'automóvel', 'veículo'],
                'is_popular' => true,
            ],
            [
                'name' => 'Comissões',
                'description' => 'Comissões sobre vendas e intermediações',
                'type' => 'income',
                'group' => 'Vendas',
                'icon' => 'bi-percent',
                'color' => '#17a2b8',
                'keywords' => ['comissão', 'venda', 'intermediação', 'percentual'],
                'is_popular' => true,
            ],
            [
                'name' => 'Prestação de Serviços',
                'description' => 'Receitas de serviços prestados',
                'type' => 'income',
                'group' => 'Vendas',
                'icon' => 'bi-tools',
                'color' => '#fd7e14',
                'keywords' => ['serviço', 'prestação', 'trabalho', 'mão de obra'],
                'is_popular' => true,
            ],
            [
                'name' => 'Consultoria',
                'description' => 'Receitas de serviços de consultoria',
                'type' => 'income',
                'group' => 'Vendas',
                'icon' => 'bi-person-check',
                'color' => '#6f42c1',
                'keywords' => ['consultoria', 'assessoria', 'orientação', 'especialista'],
            ],

            // RECEITAS - FINANCEIRO
            [
                'name' => 'Juros Recebidos',
                'description' => 'Juros de aplicações financeiras e investimentos',
                'type' => 'income',
                'group' => 'Financeiro',
                'icon' => 'bi-graph-up',
                'color' => '#20c997',
                'keywords' => ['juros', 'aplicação', 'investimento', 'rendimento'],
            ],
            [
                'name' => 'Dividendos',
                'description' => 'Dividendos de ações e participações societárias',
                'type' => 'income',
                'group' => 'Financeiro',
                'icon' => 'bi-cash-stack',
                'color' => '#28a745',
                'keywords' => ['dividendo', 'ação', 'participação', 'lucro'],
            ],
            [
                'name' => 'Empréstimos Recebidos',
                'description' => 'Valores recebidos de empréstimos concedidos',
                'type' => 'income',
                'group' => 'Financeiro',
                'icon' => 'bi-arrow-down-circle',
                'color' => '#ffc107',
                'keywords' => ['empréstimo', 'recebido', 'dinheiro', 'pagamento'],
            ],

            // RECEITAS - OUTROS
            [
                'name' => 'Aluguéis Recebidos',
                'description' => 'Receitas de aluguéis de imóveis',
                'type' => 'income',
                'group' => 'Outros',
                'icon' => 'bi-house-check',
                'color' => '#795548',
                'keywords' => ['aluguel', 'imóvel', 'locação', 'inquilino'],
            ],
            [
                'name' => 'Vendas Diversas',
                'description' => 'Outras vendas não categorizadas',
                'type' => 'income',
                'group' => 'Outros',
                'icon' => 'bi-bag-check',
                'color' => '#6c757d',
                'keywords' => ['venda', 'diversos', 'outros', 'variados'],
            ],
            [
                'name' => 'Reembolsos',
                'description' => 'Valores reembolsados por terceiros',
                'type' => 'income',
                'group' => 'Outros',
                'icon' => 'bi-arrow-counterclockwise',
                'color' => '#17a2b8',
                'keywords' => ['reembolso', 'devolução', 'restituição', 'volta'],
            ],

            // DESPESAS ADICIONAIS
            [
                'name' => 'Alimentação',
                'description' => 'Gastos com alimentação e refeições',
                'type' => 'expense',
                'group' => 'Pessoal',
                'icon' => 'bi-cup-hot',
                'color' => '#ff5722',
                'keywords' => ['comida', 'refeição', 'restaurante', 'lanche'],
            ],
            [
                'name' => 'Transporte',
                'description' => 'Gastos com transporte público, táxi e aplicativos',
                'type' => 'expense',
                'group' => 'Pessoal',
                'icon' => 'bi-bus-front',
                'color' => '#607d8b',
                'keywords' => ['ônibus', 'metrô', 'táxi', 'uber'],
            ],
            [
                'name' => 'Educação e Treinamento',
                'description' => 'Cursos, treinamentos e capacitação profissional',
                'type' => 'expense',
                'group' => 'Desenvolvimento',
                'icon' => 'bi-book',
                'color' => '#3f51b5',
                'keywords' => ['curso', 'treinamento', 'educação', 'capacitação'],
            ],
            [
                'name' => 'Eventos e Networking',
                'description' => 'Participação em eventos, feiras e networking',
                'type' => 'expense',
                'group' => 'Desenvolvimento',
                'icon' => 'bi-people',
                'color' => '#e91e63',
                'keywords' => ['evento', 'feira', 'networking', 'congresso'],
            ],
        ];

        foreach ($categories as $category) {
            DefaultCategory::create($category);
        }
    }
}
