# Deploy para cPanel - Sistema de Gestão Financeira

## Pré-requisitos
- Hospedagem com suporte a PHP 8.1+
- MySQL 5.7+ ou MariaDB 10.3+
- Composer instalado
- Acesso SSH (recomendado)

## Estrutura de Arquivos no cPanel

\`\`\`
public_html/
├── sistema-gestao/          # Pasta principal da aplicação
│   ├── app/
│   ├── bootstrap/
│   ├── config/
│   ├── database/
│   ├── resources/
│   ├── routes/
│   ├── storage/
│   ├── vendor/
│   ├── .env
│   ├── artisan
│   ├── composer.json
│   └── ...
└── public/                  # Conteúdo da pasta public do Laravel
    ├── index.php
    ├── css/
    ├── js/
    └── ...
\`\`\`

## Passos para Deploy

### 1. Upload dos Arquivos
- Faça upload de todos os arquivos EXCETO a pasta `public`
- Coloque os arquivos em `public_html/sistema-gestao/`
- Mova o conteúdo da pasta `public` para `public_html/`

### 2. Configurar .env
Crie o arquivo `.env` em `public_html/sistema-gestao/.env`:

\`\`\`env
APP_NAME="Sistema de Gestão Financeira"
APP_ENV=production
APP_KEY=base64:GERAR_NOVA_CHAVE
APP_DEBUG=false
APP_URL=https://seudominio.com

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=error

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=seu_banco_de_dados
DB_USERNAME=seu_usuario
DB_PASSWORD=sua_senha

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MEMCACHED_HOST=127.0.0.1

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=smtp
MAIL_HOST=mailpit
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="hello@example.com"
MAIL_FROM_NAME="${APP_NAME}"

AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=
AWS_USE_PATH_STYLE_ENDPOINT=false

PUSHER_APP_ID=
PUSHER_APP_KEY=
PUSHER_APP_SECRET=
PUSHER_HOST=
PUSHER_PORT=443
PUSHER_SCHEME=https
PUSHER_APP_CLUSTER=mt1

VITE_PUSHER_APP_KEY="${PUSHER_APP_KEY}"
VITE_PUSHER_HOST="${PUSHER_HOST}"
VITE_PUSHER_PORT="${PUSHER_PORT}"
VITE_PUSHER_SCHEME="${PUSHER_SCHEME}"
VITE_PUSHER_APP_CLUSTER="${PUSHER_APP_CLUSTER}"
\`\`\`

### 3. Ajustar index.php
Edite `public_html/index.php`:

\`\`\`php
<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Ajustar caminho para a aplicação
if (file_exists($maintenance = __DIR__.'/sistema-gestao/storage/framework/maintenance.php')) {
    require $maintenance;
}

require __DIR__.'/sistema-gestao/vendor/autoload.php';

$app = require_once __DIR__.'/sistema-gestao/bootstrap/app.php';

$kernel = $app->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response);
\`\`\`

### 4. Configurar Permissões
Execute via SSH ou File Manager:
\`\`\`bash
chmod -R 755 public_html/sistema-gestao/
chmod -R 775 public_html/sistema-gestao/storage/
chmod -R 775 public_html/sistema-gestao/bootstrap/cache/
\`\`\`

### 5. Instalar Dependências
Via SSH:
\`\`\`bash
cd public_html/sistema-gestao/
composer install --optimize-autoloader --no-dev
\`\`\`

### 6. Configurar Aplicação
\`\`\`bash
php artisan key:generate
php artisan config:cache
php artisan route:cache
php artisan view:cache
\`\`\`

### 7. Executar Migrações
\`\`\`bash
php artisan migrate --force
php artisan db:seed --class=DefaultCategoriesSeeder
\`\`\`

### 8. Configurar Cron Jobs
No cPanel, adicione um Cron Job:
\`\`\`
*/5 * * * * cd /home/usuario/public_html/sistema-gestao && php artisan schedule:run >> /dev/null 2>&1
\`\`\`

## Configurações Adicionais

### .htaccess para Subpasta
Se instalar em subpasta, crie `.htaccess` em `public_html/`:

```apache
RewriteEngine On
RewriteRule ^sistema-gestao/(.*)$ sistema-gestao/public/$1 [L]
