#!/bin/bash

# Script de instalação automática para cPanel
# Sistema de Gestão Financeira

echo "=== Instalação do Sistema de Gestão Financeira ==="
echo ""

# Verificar se está no diretório correto
if [ ! -f "artisan" ]; then
    echo "❌ Erro: Execute este script no diretório raiz da aplicação Laravel"
    exit 1
fi

echo "📁 Configurando permissões..."
chmod -R 755 .
chmod -R 775 storage/
chmod -R 775 bootstrap/cache/

echo "📦 Instalando dependências..."
if command -v composer &> /dev/null; then
    composer install --optimize-autoloader --no-dev
else
    echo "❌ Composer não encontrado. Instale o Composer primeiro."
    exit 1
fi

echo "🔑 Gerando chave da aplicação..."
php artisan key:generate --force

echo "⚙️ Configurando cache..."
php artisan config:cache
php artisan route:cache
php artisan view:cache

echo "🗄️ Executando migrações..."
php artisan migrate --force

echo "🌱 Executando seeders..."
php artisan db:seed --class=DefaultCategoriesSeeder --force

echo "🧹 Limpando cache..."
php artisan cache:clear

echo ""
echo "✅ Instalação concluída com sucesso!"
echo ""
echo "📋 Próximos passos:"
echo "1. Configure o arquivo .env com suas credenciais"
echo "2. Configure o cron job para: php artisan schedule:run"
echo "3. Acesse o sistema e faça o primeiro login"
echo ""
echo "🔗 Documentação completa em: deploy/cpanel-setup.md"
