import axios from "axios"
import { showLoading, hideLoading, showNotification } from "./path/to/loadingUtils" // Import the functions here

window.axios = axios

window.axios.defaults.headers.common["X-Requested-With"] = "XMLHttpRequest"

// Configurar token CSRF
const token = document.head.querySelector('meta[name="csrf-token"]')

if (token) {
  window.axios.defaults.headers.common["X-CSRF-TOKEN"] = token.content
} else {
  console.error("CSRF token not found: https://laravel.com/docs/csrf#csrf-x-csrf-token")
}

// Configurar interceptors para loading
window.axios.interceptors.request.use(
  (config) => {
    // Mostrar loading se não for uma requisição silenciosa
    if (!config.silent) {
      showLoading()
    }
    return config
  },
  (error) => {
    hideLoading()
    return Promise.reject(error)
  },
)

window.axios.interceptors.response.use(
  (response) => {
    hideLoading()
    return response
  },
  (error) => {
    hideLoading()

    // Tratar erros comuns
    if (error.response) {
      switch (error.response.status) {
        case 401:
          window.location.href = "/login"
          break
        case 403:
          showNotification("Você não tem permissão para realizar esta ação.", "error")
          break
        case 422:
          // Erros de validação - serão tratados pelos formulários
          break
        case 500:
          showNotification("Erro interno do servidor. Tente novamente.", "error")
          break
        default:
          showNotification("Ocorreu um erro inesperado.", "error")
      }
    }

    return Promise.reject(error)
  },
)

// Echo para WebSockets (se necessário)
// import Echo from 'laravel-echo';
// import Pusher from 'pusher-js';
// window.Pusher = Pusher;

// window.Echo = new Echo({
//     broadcaster: 'pusher',
//     key: import.meta.env.VITE_PUSHER_APP_KEY,
//     cluster: import.meta.env.VITE_PUSHER_APP_CLUSTER ?? 'mt1',
//     wsHost: import.meta.env.VITE_PUSHER_HOST ? import.meta.env.VITE_PUSHER_HOST : `ws-${import.meta.env.VITE_PUSHER_APP_CLUSTER}.pusher-channels.com`,
//     wsPort: import.meta.env.VITE_PUSHER_PORT ?? 80,
//     wssPort: import.meta.env.VITE_PUSHER_PORT ?? 443,
//     forceTLS: (import.meta.env.VITE_PUSHER_SCHEME ?? 'https') === 'https',
//     enabledTransports: ['ws', 'wss'],
// });
