@extends('layouts.app')

@section('title', 'Contas a Receber - Sistema de Gestão')
@section('page-title', 'Contas a Receber')

@section('content')
<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">A Receber</h6>
                        <h4>R$ {{ number_format($stats['total_pending'], 2, ',', '.') }}</h4>
                    </div>
                    <i class="bi bi-cash-coin fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Em Atraso</h6>
                        <h4>R$ {{ number_format($stats['total_overdue'], 2, ',', '.') }}</h4>
                    </div>
                    <i class="bi bi-exclamation-triangle fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Recebido (Mês)</h6>
                        <h4>R$ {{ number_format($stats['total_received_month'], 2, ',', '.') }}</h4>
                    </div>
                    <i class="bi bi-check-circle fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0">Contas a Receber</h4>
        <p class="text-muted">Gerencie suas contas a receber</p>
    </div>
    <a href="{{ route('accounts-receivable.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Nova Conta
    </a>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Buscar</label>
                <input type="text" class="form-control" name="search" 
                       value="{{ request('search') }}" placeholder="Descrição">
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                    <option value="">Todos</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pendente</option>
                    <option value="received" {{ request('status') === 'received' ? 'selected' : '' }}>Recebido</option>
                    <option value="overdue" {{ request('status') === 'overdue' ? 'selected' : '' }}>Atrasado</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Cliente</label>
                <select class="form-select" name="customer_id">
                    <option value="">Todos</option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                            {{ $customer->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">De</label>
                <input type="date" class="form-control" name="date_from" value="{{ request('date_from') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Até</label>
                <input type="date" class="form-control" name="date_to" value="{{ request('date_to') }}">
            </div>
            <div class="col-md-1 d-flex align-items-end">
                <button type="submit" class="btn btn-outline-primary">
                    <i class="bi bi-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Contas -->
<div class="card">
    <div class="card-body">
        @if($accounts->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Descrição</th>
                            <th>Cliente</th>
                            <th>Valor</th>
                            <th>Vencimento</th>
                            <th>Status</th>
                            <th width="150">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($accounts as $account)
                            <tr class="{{ $account->status === 'pending' && $account->due_date < now() ? 'table-danger' : '' }}">
                                <td>
                                    <div class="fw-bold">{{ $account->description }}</div>
                                    @if($account->document_number)
                                        <small class="text-muted">Doc: {{ $account->document_number }}</small>
                                    @endif
                                </td>
                                <td>
                                    {{ $account->customer->name ?? '-' }}
                                </td>
                                <td>
                                    <span class="fw-bold text-success">
                                        R$ {{ number_format($account->amount, 2, ',', '.') }}
                                    </span>
                                </td>
                                <td>
                                    {{ $account->due_date->format('d/m/Y') }}
                                    @if($account->status === 'pending' && $account->due_date < now())
                                        <br><small class="text-danger">
                                            {{ $account->due_date->diffForHumans() }}
                                        </small>
                                    @endif
                                </td>
                                <td>
                                    @switch($account->status)
                                        @case('pending')
                                            @if($account->due_date < now())
                                                <span class="badge bg-danger">Atrasado</span>
                                            @else
                                                <span class="badge bg-warning">Pendente</span>
                                            @endif
                                            @break
                                        @case('received')
                                            <span class="badge bg-success">Recebido</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-secondary">Cancelado</span>
                                            @break
                                    @endswitch
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('accounts-receivable.show', $account) }}" 
                                           class="btn btn-outline-primary" title="Ver Detalhes">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        @if($account->status === 'pending')
                                            <button type="button" class="btn btn-outline-success" 
                                                    onclick="showReceiveModal({{ $account->id }})" title="Receber">
                                                <i class="bi bi-check-circle"></i>
                                            </button>
                                        @endif
                                        <a href="{{ route('accounts-receivable.edit', $account) }}" 
                                           class="btn btn-outline-warning" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{ $accounts->links() }}
        @else
            <div class="text-center py-5">
                <i class="bi bi-cash-coin display-1 text-muted"></i>
                <h5 class="mt-3">Nenhuma conta encontrada</h5>
                <p class="text-muted">Comece cadastrando sua primeira conta a receber.</p>
                <a href="{{ route('accounts-receivable.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> Nova Conta
                </a>
            </div>
        @endif
    </div>
</div>

<!-- Modal de Recebimento -->
<div class="modal fade" id="receiveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Registrar Recebimento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="receiveForm" method="POST">
                @csrf
                @method('PATCH')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Data do Recebimento *</label>
                        <input type="date" class="form-control" name="received_date" 
                               value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">Confirmar Recebimento</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function showReceiveModal(accountId) {
    const form = document.getElementById('receiveForm');
    form.action = `/accounts-receivable/${accountId}/receive`;
    new bootstrap.Modal(document.getElementById('receiveModal')).show();
}
</script>
@endpush
