@extends('layouts.app')

@section('title', 'Conciliação Bancária - Sistema de Gestão')
@section('page-title', 'Conciliação Bancária')

@section('content')
<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Pendentes</h6>
                        <h4>{{ $stats['total_pending'] }}</h4>
                    </div>
                    <i class="bi bi-clock fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Conciliados</h6>
                        <h4>{{ $stats['total_reconciled'] }}</h4>
                    </div>
                    <i class="bi bi-check-circle fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Valor Pendente</h6>
                        <h4>R$ {{ number_format($stats['pending_amount'], 2, ',', '.') }}</h4>
                    </div>
                    <i class="bi bi-currency-dollar fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0">Conciliação Bancária</h4>
        <p class="text-muted">Importe e concilie seus extratos bancários</p>
    </div>
    <div class="btn-group">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#importModal">
            <i class="bi bi-upload"></i> Importar Extrato
        </button>
        <button type="button" class="btn btn-success" onclick="autoReconcile()">
            <i class="bi bi-magic"></i> Conciliação Automática
        </button>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Conta Bancária</label>
                <select class="form-select" name="bank_account_id">
                    <option value="">Todas as contas</option>
                    @foreach($bankAccounts as $account)
                        <option value="{{ $account->id }}" {{ request('bank_account_id') == $account->id ? 'selected' : '' }}>
                            {{ $account->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                    <option value="">Todos</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pendente</option>
                    <option value="reconciled" {{ request('status') === 'reconciled' ? 'selected' : '' }}>Conciliado</option>
                    <option value="ignored" {{ request('status') === 'ignored' ? 'selected' : '' }}>Ignorado</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Tipo</label>
                <select class="form-select" name="type">
                    <option value="">Todos</option>
                    <option value="credit" {{ request('type') === 'credit' ? 'selected' : '' }}>Crédito</option>
                    <option value="debit" {{ request('type') === 'debit' ? 'selected' : '' }}>Débito</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">De</label>
                <input type="date" class="form-control" name="date_from" value="{{ request('date_from') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Até</label>
                <input type="date" class="form-control" name="date_to" value="{{ request('date_to') }}">
            </div>
            <div class="col-md-1 d-flex align-items-end">
                <button type="submit" class="btn btn-outline-primary">
                    <i class="bi bi-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Transações -->
<div class="card">
    <div class="card-body">
        @if($reconciliations->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Descrição</th>
                            <th>Conta</th>
                            <th>Tipo</th>
                            <th>Valor</th>
                            <th>Status</th>
                            <th>Vinculado</th>
                            <th width="150">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($reconciliations as $reconciliation)
                            <tr>
                                <td>{{ $reconciliation->transaction_date->format('d/m/Y') }}</td>
                                <td>
                                    <div class="fw-bold">{{ $reconciliation->description }}</div>
                                    @if($reconciliation->document_number)
                                        <small class="text-muted">Doc: {{ $reconciliation->document_number }}</small>
                                    @endif
                                </td>
                                <td>{{ $reconciliation->bankAccount->name }}</td>
                                <td>{!! $reconciliation->getTypeBadgeAttribute() !!}</td>
                                <td>
                                    <span class="{{ $reconciliation->type === 'credit' ? 'text-success' : 'text-danger' }} fw-bold">
                                        {{ $reconciliation->type === 'credit' ? '+' : '-' }}R$ {{ number_format($reconciliation->amount, 2, ',', '.') }}
                                    </span>
                                </td>
                                <td>{!! $reconciliation->getStatusBadgeAttribute() !!}</td>
                                <td>
                                    @if($reconciliation->account_payable_id)
                                        <small class="text-info">Conta a Pagar</small>
                                    @elseif($reconciliation->account_receivable_id)
                                        <small class="text-success">Conta a Receber</small>
                                    @elseif($reconciliation->category)
                                        <small class="text-muted">{{ $reconciliation->category->name }}</small>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($reconciliation->status === 'pending')
                                        <button type="button" class="btn btn-sm btn-outline-primary" 
                                                onclick="showReconcileModal({{ $reconciliation->id }})">
                                            <i class="bi bi-link"></i> Conciliar
                                        </button>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{ $reconciliations->links() }}
        @else
            <div class="text-center py-5">
                <i class="bi bi-bank display-1 text-muted"></i>
                <h5 class="mt-3">Nenhuma transação encontrada</h5>
                <p class="text-muted">Importe seu primeiro extrato bancário.</p>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#importModal">
                    <i class="bi bi-upload"></i> Importar Extrato
                </button>
            </div>
        @endif
    </div>
</div>

<!-- Modal de Importação -->
<div class="modal fade" id="importModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Importar Extrato Bancário</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('bank-reconciliation.import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Tipo de Conta *</label>
                            <select class="form-select" name="account_type" id="accountType" required>
                                <option value="">Selecione</option>
                                <option value="bank">Conta Bancária</option>
                                <option value="credit_card">Cartão de Crédito</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Banco *</label>
                            <select class="form-select" name="bank_name" required>
                                <option value="">Selecione</option>
                                <option value="itau">Itaú</option>
                                <option value="bradesco">Bradesco</option>
                                <option value="santander">Santander</option>
                                <option value="bb">Banco do Brasil</option>
                                <option value="caixa">Caixa Econômica</option>
                                <option value="nubank">Nubank</option>
                                <option value="inter">Inter</option>
                                <option value="generic">Genérico</option>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3" id="bankAccountDiv" style="display: none;">
                            <label class="form-label">Conta Bancária</label>
                            <select class="form-select" name="bank_account_id">
                                <option value="">Selecione</option>
                                @foreach($bankAccounts as $account)
                                    <option value="{{ $account->id }}">{{ $account->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3" id="creditCardDiv" style="display: none;">
                            <label class="form-label">Cartão de Crédito</label>
                            <select class="form-select" name="credit_card_id">
                                <option value="">Selecione</option>
                                @foreach($creditCards as $card)
                                    <option value="{{ $card->id }}">{{ $card->name }} ({{ $card->masked_number }})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Tipo de Arquivo *</label>
                            <select class="form-select" name="file_type" required>
                                <option value="">Selecione</option>
                                <option value="csv">CSV</option>
                                <option value="excel">Excel (XLS/XLSX)</option>
                                <option value="pdf">PDF</option>
                                <option value="txt">TXT</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Arquivo do Extrato *</label>
                        <input type="file" class="form-control" name="file" 
                               accept=".pdf,.csv,.xls,.xlsx,.txt" required>
                        <div class="form-text">
                            Formatos aceitos: PDF, CSV, Excel (XLS/XLSX), TXT. Tamanho máximo: 10MB
                        </div>
                    </div>

                    <div class="alert alert-info">
                        <h6><i class="bi bi-info-circle"></i> Dicas de Importação:</h6>
                        <ul class="mb-0">
                            <li><strong>CSV:</strong> Certifique-se que as colunas estão na ordem: Data, Descrição, Valor</li>
                            <li><strong>PDF:</strong> Funciona melhor com extratos de texto (não escaneados)</li>
                            <li><strong>Excel:</strong> Primeira linha deve conter os cabeçalhos</li>
                            <li><strong>Duplicatas:</strong> Transações já importadas serão ignoradas automaticamente</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-upload"></i> Importar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de Conciliação -->
<div class="modal fade" id="reconcileModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Conciliar Transação</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="reconcileForm" method="POST">
                @csrf
                @method('PATCH')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Ação *</label>
                        <select class="form-select" name="action" id="reconcileAction" required>
                            <option value="">Selecione</option>
                            <option value="reconcile">Conciliar como Categoria</option>
                            <option value="link_payable">Vincular a Conta a Pagar</option>
                            <option value="link_receivable">Vincular a Conta a Receber</option>
                            <option value="ignore">Ignorar Transação</option>
                        </select>
                    </div>

                    <div id="categoryDiv" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label">Categoria</label>
                            <select class="form-select" name="category_id">
                                <option value="">Selecione uma categoria</option>
                                <!-- Categorias serão carregadas via JavaScript -->
                            </select>
                        </div>
                    </div>

                    <div id="payableDiv" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label">Conta a Pagar</label>
                            <select class="form-select" name="account_payable_id">
                                <option value="">Selecione</option>
                                <!-- Contas serão carregadas via JavaScript -->
                            </select>
                        </div>
                    </div>

                    <div id="receivableDiv" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label">Conta a Receber</label>
                            <select class="form-select" name="account_receivable_id">
                                <option value="">Selecione</option>
                                <!-- Contas serão carregadas via JavaScript -->
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Confirmar</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Controle do tipo de conta
document.getElementById('accountType').addEventListener('change', function() {
    const bankDiv = document.getElementById('bankAccountDiv');
    const cardDiv = document.getElementById('creditCardDiv');
    
    if (this.value === 'bank') {
        bankDiv.style.display = 'block';
        cardDiv.style.display = 'none';
        bankDiv.querySelector('select').required = true;
        cardDiv.querySelector('select').required = false;
    } else if (this.value === 'credit_card') {
        bankDiv.style.display = 'none';
        cardDiv.style.display = 'block';
        bankDiv.querySelector('select').required = false;
        cardDiv.querySelector('select').required = true;
    } else {
        bankDiv.style.display = 'none';
        cardDiv.style.display = 'none';
        bankDiv.querySelector('select').required = false;
        cardDiv.querySelector('select').required = false;
    }
});

// Controle do modal de conciliação
document.getElementById('reconcileAction').addEventListener('change', function() {
    const categoryDiv = document.getElementById('categoryDiv');
    const payableDiv = document.getElementById('payableDiv');
    const receivableDiv = document.getElementById('receivableDiv');
    
    // Esconder todos
    categoryDiv.style.display = 'none';
    payableDiv.style.display = 'none';
    receivableDiv.style.display = 'none';
    
    // Mostrar conforme seleção
    switch(this.value) {
        case 'reconcile':
            categoryDiv.style.display = 'block';
            break;
        case 'link_payable':
            payableDiv.style.display = 'block';
            break;
        case 'link_receivable':
            receivableDiv.style.display = 'block';
            break;
    }
});

function showReconcileModal(reconciliationId) {
    const form = document.getElementById('reconcileForm');
    form.action = `/bank-reconciliation/${reconciliationId}/reconcile`;
    new bootstrap.Modal(document.getElementById('reconcileModal')).show();
}

function autoReconcile() {
    if (confirm('Deseja executar a conciliação automática? Esta ação irá tentar vincular automaticamente as transações com contas a pagar/receber correspondentes.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '{{ route("bank-reconciliation.auto-reconcile") }}';
        
        const csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '_token';
        csrf.value = '{{ csrf_token() }}';
        form.appendChild(csrf);
        
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endpush
