@extends('layouts.app')

@section('title', 'Veículos - Sistema de Gestão')
@section('page-title', 'Veículos')

@section('content')
<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Total de Veículos</h6>
                        <h4>{{ $stats['total_cars'] }}</h4>
                    </div>
                    <i class="bi bi-car-front fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Em Estoque</h6>
                        <h4>{{ $stats['cars_owned'] }}</h4>
                    </div>
                    <i class="bi bi-check-circle fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Vendidos</h6>
                        <h4>{{ $stats['cars_sold'] }}</h4>
                    </div>
                    <i class="bi bi-currency-dollar fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title">Investido</h6>
                        <h4>R$ {{ number_format($stats['total_invested'], 0, ',', '.') }}</h4>
                    </div>
                    <i class="bi bi-graph-up fa-2x"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0">Gerenciar Veículos</h4>
        <p class="text-muted">Controle seu estoque de veículos</p>
    </div>
    <a href="{{ route('cars.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Novo Veículo
    </a>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Buscar</label>
                <input type="text" class="form-control" name="search" 
                       value="{{ request('search') }}" 
                       placeholder="Modelo, marca ou placa">
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                    <option value="">Todos</option>
                    <option value="owned" {{ request('status') === 'owned' ? 'selected' : '' }}>Em Estoque</option>
                    <option value="sold" {{ request('status') === 'sold' ? 'selected' : '' }}>Vendidos</option>
                    <option value="maintenance" {{ request('status') === 'maintenance' ? 'selected' : '' }}>Manutenção</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-outline-primary me-2">
                    <i class="bi bi-search"></i> Filtrar
                </button>
                <a href="{{ route('cars.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-x-circle"></i> Limpar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Grid de Veículos -->
@if($cars->count() > 0)
    <div class="row">
        @foreach($cars as $car)
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100">
                    @if($car->photos && count($car->photos) > 0)
                        <img src="{{ Storage::url($car->photos[0]) }}" class="card-img-top" 
                             style="height: 200px; object-fit: cover;" alt="{{ $car->model }}">
                    @else
                        <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                             style="height: 200px;">
                            <i class="bi bi-car-front display-4 text-muted"></i>
                        </div>
                    @endif
                    
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h5 class="card-title mb-0">{{ $car->brand }} {{ $car->model }}</h5>
                            @switch($car->status)
                                @case('owned')
                                    <span class="badge bg-success">Em Estoque</span>
                                    @break
                                @case('sold')
                                    <span class="badge bg-info">Vendido</span>
                                    @break
                                @case('maintenance')
                                    <span class="badge bg-warning">Manutenção</span>
                                    @break
                            @endswitch
                        </div>
                        
                        <div class="mb-2">
                            @if($car->year)
                                <small class="text-muted">Ano: {{ $car->year }}</small><br>
                            @endif
                            @if($car->plate)
                                <small class="text-muted">Placa: {{ $car->plate }}</small><br>
                            @endif
                            @if($car->color)
                                <small class="text-muted">Cor: {{ $car->color }}</small>
                            @endif
                        </div>
                        
                        <div class="mb-3">
                            @if($car->purchase_price)
                                <div><strong>Compra:</strong> R$ {{ number_format($car->purchase_price, 2, ',', '.') }}</div>
                            @endif
                            @if($car->sale_price)
                                <div><strong>Venda:</strong> R$ {{ number_format($car->sale_price, 2, ',', '.') }}</div>
                            @endif
                            <div><strong>Despesas:</strong> R$ {{ number_format($car->expenses_sum_amount ?? 0, 2, ',', '.') }}</div>
                            
                            @if($car->status === 'sold' && $car->purchase_price && $car->sale_price)
                                @php
                                    $profit = $car->sale_price - $car->purchase_price - ($car->expenses_sum_amount ?? 0);
                                    $class = $profit >= 0 ? 'text-success' : 'text-danger';
                                @endphp
                                <div class="{{ $class }}">
                                    <strong>{{ $profit >= 0 ? 'Lucro' : 'Prejuízo' }}:</strong> 
                                    R$ {{ number_format(abs($profit), 2, ',', '.') }}
                                </div>
                            @endif
                        </div>
                        
                        <div class="mt-auto">
                            <div class="btn-group w-100">
                                <a href="{{ route('cars.show', $car) }}" class="btn btn-outline-primary">
                                    <i class="bi bi-eye"></i> Detalhes
                                </a>
                                <a href="{{ route('cars.edit', $car) }}" class="btn btn-outline-warning">
                                    <i class="bi bi-pencil"></i> Editar
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    {{ $cars->links() }}
@else
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-car-front display-1 text-muted"></i>
            <h5 class="mt-3">Nenhum veículo encontrado</h5>
            <p class="text-muted">Comece cadastrando seu primeiro veículo.</p>
            <a href="{{ route('cars.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Cadastrar Veículo
            </a>
        </div>
    </div>
@endif
@endsection
