@extends('layouts.app')

@section('title', isset($category) ? 'Editar Categoria' : 'Nova Categoria')
@section('page-title', isset($category) ? 'Editar Categoria' : 'Nova Categoria')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-{{ isset($category) ? 'pencil' : 'plus-circle' }}"></i>
                    {{ isset($category) ? 'Editar' : 'Nova' }} Categoria
                </h5>
            </div>
            
            <div class="card-body">
                <form method="POST" action="{{ isset($category) ? route('categories.update', $category) : route('categories.store') }}">
                    @csrf
                    @if(isset($category))
                        @method('PUT')
                    @endif
                    
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="name" class="form-label">Nome *</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                       id="name" name="name" 
                                       value="{{ old('name', $category->name ?? '') }}" 
                                       required maxlength="255">
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="type" class="form-label">Tipo *</label>
                                <select class="form-select @error('type') is-invalid @enderror" 
                                        id="type" name="type" required>
                                    <option value="">Selecione...</option>
                                    <option value="income" {{ old('type', $category->type ?? '') === 'income' ? 'selected' : '' }}>
                                        Receita
                                    </option>
                                    <option value="expense" {{ old('type', $category->type ?? '') === 'expense' ? 'selected' : '' }}>
                                        Despesa
                                    </option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Descrição</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" name="description" rows="3" 
                                  maxlength="1000">{{ old('description', $category->description ?? '') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Descreva o propósito desta categoria (opcional).</div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="icon" class="form-label">Ícone *</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i id="icon-preview" class="{{ old('icon', $category->icon ?? 'bi-tag') }}"></i>
                                    </span>
                                    <select class="form-select @error('icon') is-invalid @enderror" 
                                            id="icon" name="icon" required>
                                        <option value="">Selecione um ícone...</option>
                                        <optgroup label="Geral">
                                            <option value="bi-tag" {{ old('icon', $category->icon ?? '') === 'bi-tag' ? 'selected' : '' }}>Tag</option>
                                            <option value="bi-folder" {{ old('icon', $category->icon ?? '') === 'bi-folder' ? 'selected' : '' }}>Pasta</option>
                                            <option value="bi-bookmark" {{ old('icon', $category->icon ?? '') === 'bi-bookmark' ? 'selected' : '' }}>Marcador</option>
                                        </optgroup>
                                        <optgroup label="Financeiro">
                                            <option value="bi-cash-coin" {{ old('icon', $category->icon ?? '') === 'bi-cash-coin' ? 'selected' : '' }}>Dinheiro</option>
                                            <option value="bi-credit-card" {{ old('icon', $category->icon ?? '') === 'bi-credit-card' ? 'selected' : '' }}>Cartão</option>
                                            <option value="bi-bank" {{ old('icon', $category->icon ?? '') === 'bi-bank' ? 'selected' : '' }}>Banco</option>
                                            <option value="bi-graph-up" {{ old('icon', $category->icon ?? '') === 'bi-graph-up' ? 'selected' : '' }}>Gráfico</option>
                                        </optgroup>
                                        <optgroup label="Veículos">
                                            <option value="bi-car-front" {{ old('icon', $category->icon ?? '') === 'bi-car-front' ? 'selected' : '' }}>Carro</option>
                                            <option value="bi-fuel-pump" {{ old('icon', $category->icon ?? '') === 'bi-fuel-pump' ? 'selected' : '' }}>Combustível</option>
                                            <option value="bi-tools" {{ old('icon', $category->icon ?? '') === 'bi-tools' ? 'selected' : '' }}>Ferramentas</option>
                                        </optgroup>
                                        <optgroup label="Escritório">
                                            <option value="bi-building" {{ old('icon', $category->icon ?? '') === 'bi-building' ? 'selected' : '' }}>Prédio</option>
                                            <option value="bi-laptop" {{ old('icon', $category->icon ?? '') === 'bi-laptop' ? 'selected' : '' }}>Laptop</option>
                                            <option value="bi-printer" {{ old('icon', $category->icon ?? '') === 'bi-printer' ? 'selected' : '' }}>Impressora</option>
                                        </optgroup>
                                    </select>
                                </div>
                                @error('icon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="color" class="form-label">Cor *</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color @error('color') is-invalid @enderror" 
                                           id="color" name="color" 
                                           value="{{ old('color', $category->color ?? '#6c757d') }}" 
                                           required>
                                    <input type="text" class="form-control" id="color-text" 
                                           value="{{ old('color', $category->color ?? '#6c757d') }}" 
                                           pattern="^#[0-9A-Fa-f]{6}$" readonly>
                                </div>
                                @error('color')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Escolha uma cor para identificar esta categoria.</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="keywords_string" class="form-label">Palavras-chave</label>
                        <input type="text" class="form-control @error('keywords_string') is-invalid @enderror" 
                               id="keywords_string" name="keywords_string" 
                               value="{{ old('keywords_string', isset($category) ? $category->keywords_string : '') }}" 
                               maxlength="500">
                        @error('keywords_string')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Separe as palavras-chave por vírgula. Ex: combustível, gasolina, posto</div>
                    </div>
                    
                    <!-- Preview -->
                    <div class="mb-4">
                        <label class="form-label">Preview</label>
                        <div class="card" style="max-width: 300px;">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-2">
                                    <span id="preview-icon" class="me-2" style="color: {{ old('color', $category->color ?? '#6c757d') }}; font-size: 1.2em;">
                                        <i class="{{ old('icon', $category->icon ?? 'bi-tag') }}"></i>
                                    </span>
                                    <h6 id="preview-name" class="card-title mb-0">{{ old('name', $category->name ?? 'Nome da Categoria') }}</h6>
                                </div>
                                <p id="preview-description" class="card-text text-muted small">
                                    {{ old('description', $category->description ?? 'Descrição da categoria...') }}
                                </p>
                                <span id="preview-type" class="badge bg-secondary">
                                    {{ old('type', $category->type ?? '') === 'income' ? 'Receita' : (old('type', $category->type ?? '') === 'expense' ? 'Despesa' : 'Tipo') }}
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('categories.index') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Voltar
                        </a>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle"></i> 
                            {{ isset($category) ? 'Atualizar' : 'Criar' }} Categoria
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const nameInput = document.getElementById('name');
    const descriptionInput = document.getElementById('description');
    const typeSelect = document.getElementById('type');
    const iconSelect = document.getElementById('icon');
    const colorInput = document.getElementById('color');
    const colorText = document.getElementById('color-text');
    
    const previewName = document.getElementById('preview-name');
    const previewDescription = document.getElementById('preview-description');
    const previewType = document.getElementById('preview-type');
    const previewIcon = document.getElementById('preview-icon');
    const iconPreview = document.getElementById('icon-preview');
    
    function updatePreview() {
        previewName.textContent = nameInput.value || 'Nome da Categoria';
        previewDescription.textContent = descriptionInput.value || 'Descrição da categoria...';
        
        const type = typeSelect.value;
        if (type === 'income') {
            previewType.textContent = 'Receita';
            previewType.className = 'badge bg-success';
        } else if (type === 'expense') {
            previewType.textContent = 'Despesa';
            previewType.className = 'badge bg-danger';
        } else {
            previewType.textContent = 'Tipo';
            previewType.className = 'badge bg-secondary';
        }
        
        const icon = iconSelect.value || 'bi-tag';
        previewIcon.style.color = colorInput.value;
        previewIcon.innerHTML = `<i class="${icon}"></i>`;
        iconPreview.className = icon;
    }
    
    function updateColorText() {
        colorText.value = colorInput.value;
    }
    
    nameInput.addEventListener('input', updatePreview);
    descriptionInput.addEventListener('input', updatePreview);
    typeSelect.addEventListener('change', updatePreview);
    iconSelect.addEventListener('change', updatePreview);
    colorInput.addEventListener('input', function() {
        updateColorText();
        updatePreview();
    });
    
    updatePreview();
    updateColorText();
});
</script>
@endpush
