@extends('layouts.app')

@section('title', 'Categorias - Sistema de Gestão')
@section('page-title', 'Categorias')

@section('content')
<div class="row mb-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-3">
                        <h4 class="text-primary mb-0">{{ $statistics['total_available'] }}</h4>
                        <small class="text-muted">Disponíveis na Biblioteca</small>
                    </div>
                    <div class="col-3">
                        <h4 class="text-success mb-0">{{ $statistics['imported'] }}</h4>
                        <small class="text-muted">Importadas</small>
                    </div>
                    <div class="col-3">
                        <h4 class="text-info mb-0">{{ $statistics['custom'] }}</h4>
                        <small class="text-muted">Personalizadas</small>
                    </div>
                    <div class="col-3">
                        <h4 class="text-warning mb-0">{{ $statistics['import_percentage'] }}%</h4>
                        <small class="text-muted">Cobertura</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="d-grid gap-2">
            <a href="{{ route('categories.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Nova Categoria
            </a>
            <a href="{{ route('categories.library') }}" class="btn btn-success">
                <i class="bi bi-collection"></i> Biblioteca de Categorias
            </a>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Buscar</label>
                <input type="text" name="search" class="form-control" 
                       value="{{ request('search') }}" 
                       placeholder="Nome ou descrição...">
            </div>
            
            <div class="col-md-3">
                <label class="form-label">Tipo</label>
                <select name="type" class="form-select">
                    <option value="">Todos os tipos</option>
                    <option value="income" {{ request('type') === 'income' ? 'selected' : '' }}>Receita</option>
                    <option value="expense" {{ request('type') === 'expense' ? 'selected' : '' }}>Despesa</option>
                </select>
            </div>
            
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search"></i> Filtrar
                    </button>
                </div>
            </div>
            
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <div class="d-grid">
                    <a href="{{ route('categories.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-x"></i> Limpar
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Categorias -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="bi bi-tags"></i> Suas Categorias
            <span class="badge bg-secondary">{{ $categories->total() }}</span>
        </h5>
    </div>
    
    <div class="card-body">
        @if($categories->count() > 0)
            <div class="row">
                @foreach($categories as $category)
                    <div class="col-md-6 col-lg-4 mb-3">
                        <div class="card h-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div class="d-flex align-items-center">
                                        <span class="me-2" style="color: {{ $category->color }}; font-size: 1.2em;">
                                            <i class="{{ $category->icon }}"></i>
                                        </span>
                                        <h6 class="card-title mb-0">{{ $category->name }}</h6>
                                    </div>
                                    
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                                type="button" data-bs-toggle="dropdown">
                                            <i class="bi bi-three-dots"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="{{ route('categories.show', $category) }}">
                                                    <i class="bi bi-eye"></i> Visualizar
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('categories.edit', $category) }}">
                                                    <i class="bi bi-pencil"></i> Editar
                                                </a>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <form method="POST" action="{{ route('categories.destroy', $category) }}" 
                                                      onsubmit="return confirm('Tem certeza que deseja excluir esta categoria?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item text-danger">
                                                        <i class="bi bi-trash"></i> Excluir
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                
                                @if($category->description)
                                    <p class="card-text text-muted small">{{ $category->description }}</p>
                                @endif
                                
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="badge {{ $category->type === 'income' ? 'bg-success' : 'bg-danger' }}">
                                        {{ $category->type === 'income' ? 'Receita' : 'Despesa' }}
                                    </span>
                                    
                                    <small class="text-muted">
                                        <i class="bi bi-graph-up"></i> {{ $category->usage_count }} usos
                                    </small>
                                </div>
                                
                                @if($category->defaultCategory)
                                    <div class="mt-2">
                                        <span class="badge bg-info">
                                            <i class="bi bi-collection"></i> Da Biblioteca
                                        </span>
                                    </div>
                                @endif
                                
                                @if($category->keywords)
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            <i class="bi bi-tags"></i> {{ $category->keywords_string }}
                                        </small>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            
            <!-- Paginação -->
            <div class="d-flex justify-content-center">
                {{ $categories->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-tags display-1 text-muted"></i>
                <h4 class="text-muted">Nenhuma categoria encontrada</h4>
                <p class="text-muted">Comece criando uma nova categoria ou importando da biblioteca.</p>
                <div class="d-grid gap-2 d-md-block">
                    <a href="{{ route('categories.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Criar Categoria
                    </a>
                    <a href="{{ route('categories.library') }}" class="btn btn-success">
                        <i class="bi bi-collection"></i> Explorar Biblioteca
                    </a>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection
