@extends('layouts.app')

@section('title', $customer->name . ' - Sistema de Gestão')
@section('page-title', 'Detalhes do Cliente')

@section('content')
<div class="row">
    <!-- Informações do Cliente -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-person-circle"></i> {{ $customer->name }}
                </h5>
                @if($customer->active)
                    <span class="badge bg-success">Ativo</span>
                @else
                    <span class="badge bg-secondary">Inativo</span>
                @endif
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Saldo Atual:</strong>
                    @php
                        $class = $balance >= 0 ? 'text-success' : 'text-danger';
                    @endphp
                    <div class="{{ $class }} h5">
                        R$ {{ number_format(abs($balance), 2, ',', '.') }}
                        @if($balance < 0) <small>(Devedor)</small> @endif
                    </div>
                </div>

                @if($customer->email)
                    <div class="mb-2">
                        <i class="bi bi-envelope"></i> {{ $customer->email }}
                    </div>
                @endif

                @if($customer->phone)
                    <div class="mb-2">
                        <i class="bi bi-telephone"></i> {{ $customer->phone }}
                    </div>
                @endif

                @if($customer->cpf_cnpj)
                    <div class="mb-2">
                        <i class="bi bi-card-text"></i> {{ $customer->cpf_cnpj }}
                    </div>
                @endif

                @if($customer->address)
                    <div class="mb-2">
                        <i class="bi bi-geo-alt"></i> {{ $customer->address }}
                    </div>
                @endif

                <div class="mb-2">
                    <strong>Limite de Crédito:</strong> 
                    R$ {{ number_format($customer->credit_limit, 2, ',', '.') }}
                </div>

                <div class="d-grid gap-2 mt-4">
                    <a href="{{ route('customers.edit', $customer) }}" class="btn btn-warning">
                        <i class="bi bi-pencil"></i> Editar Cliente
                    </a>
                    <a href="{{ route('customers.statement', $customer) }}" class="btn btn-info">
                        <i class="bi bi-file-text"></i> Extrato Completo
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Conta Corrente -->
    <div class="col-lg-8">
        <!-- Novo Lançamento -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="bi bi-plus-circle"></i> Novo Lançamento
                </h6>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('customers.add-entry', $customer) }}">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Descrição *</label>
                            <input type="text" class="form-control" name="description" required>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Valor *</label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="number" class="form-control" name="amount" step="0.01" min="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Tipo *</label>
                            <select class="form-select" name="type" required>
                                <option value="">Selecione</option>
                                <option value="credit">Crédito (+)</option>
                                <option value="debit">Débito (-)</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Data *</label>
                            <input type="date" class="form-control" name="entry_date" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Categoria</label>
                            <select class="form-select" name="category_id">
                                <option value="">Sem categoria</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-plus"></i> Adicionar
                            </button>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="notes" rows="2"></textarea>
                    </div>
                </form>
            </div>
        </div>

        <!-- Histórico de Lançamentos -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="bi bi-clock-history"></i> Últimos Lançamentos
                </h6>
            </div>
            <div class="card-body">
                @if($entries->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Data</th>
                                    <th>Descrição</th>
                                    <th>Categoria</th>
                                    <th>Débito</th>
                                    <th>Crédito</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($entries as $entry)
                                    <tr>
                                        <td>{{ $entry->entry_date->format('d/m/Y') }}</td>
                                        <td>
                                            {{ $entry->description }}
                                            @if($entry->notes)
                                                <br><small class="text-muted">{{ $entry->notes }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($entry->category)
                                                <span class="badge" style="background-color: {{ $entry->category->color }}">
                                                    {{ $entry->category->name }}
                                                </span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($entry->type === 'debit')
                                                <span class="text-danger">
                                                    R$ {{ number_format($entry->amount, 2, ',', '.') }}
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($entry->type === 'credit')
                                                <span class="text-success">
                                                    R$ {{ number_format($entry->amount, 2, ',', '.') }}
                                                </span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    {{ $entries->links() }}
                @else
                    <div class="text-center py-4">
                        <i class="bi bi-journal-x display-4 text-muted"></i>
                        <h6 class="mt-2">Nenhum lançamento encontrado</h6>
                        <p class="text-muted">Adicione o primeiro lançamento para este cliente.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="mt-4">
    <a href="{{ route('customers.index') }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Voltar para Lista
    </a>
</div>
@endsection
