@extends('layouts.app')

@section('title', 'Dashboard - Sistema de Gestão')
@section('page-title', 'Dashboard')

@section('content')
<div class="row">
    <!-- Cards de estatísticas -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card stats-card">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Contas a Receber</div>
                        <div class="h5 mb-0 font-weight-bold">
                            R$ {{ number_format($stats['total_receivable'] ?? 0, 2, ',', '.') }}
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="bi bi-cash-coin fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Contas a Pagar</div>
                        <div class="h5 mb-0 font-weight-bold">
                            R$ {{ number_format($stats['total_payable'] ?? 0, 2, ',', '.') }}
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="bi bi-credit-card fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Total Clientes</div>
                        <div class="h5 mb-0 font-weight-bold">{{ $stats['total_customers'] ?? 0 }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="bi bi-people fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-uppercase mb-1">Veículos</div>
                        <div class="h5 mb-0 font-weight-bold">{{ $stats['total_cars'] ?? 0 }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="bi bi-car-front fa-2x text-white-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Gráfico de Fluxo de Caixa -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="bi bi-graph-up"></i> Fluxo de Caixa - Últimos 30 dias
                </h6>
            </div>
            <div class="card-body">
                <canvas id="cashFlowChart" width="400" height="200"></canvas>
            </div>
        </div>
    </div>

    <!-- Próximos Vencimentos -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="bi bi-calendar-event"></i> Próximos Vencimentos
                </h6>
            </div>
            <div class="card-body">
                @forelse($upcoming_payments ?? [] as $payment)
                    <div class="d-flex align-items-center mb-3">
                        <div class="flex-shrink-0">
                            <span class="badge bg-warning">{{ $payment->due_date->format('d/m') }}</span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="fw-bold">{{ $payment->description }}</div>
                            <div class="text-muted small">R$ {{ number_format($payment->amount, 2, ',', '.') }}</div>
                        </div>
                    </div>
                @empty
                    <p class="text-muted text-center">Nenhum vencimento próximo</p>
                @endforelse
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Contas em Atraso -->
    <div class="col-lg-6 mb-4">
        <div class="card border-left-danger">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold text-danger">
                    <i class="bi bi-exclamation-triangle"></i> Contas em Atraso
                </h6>
            </div>
            <div class="card-body">
                @forelse($overdue_accounts ?? [] as $account)
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div>
                            <div class="fw-bold">{{ $account->description }}</div>
                            <small class="text-muted">Vencimento: {{ $account->due_date->format('d/m/Y') }}</small>
                        </div>
                        <span class="badge bg-danger">R$ {{ number_format($account->amount, 2, ',', '.') }}</span>
                    </div>
                @empty
                    <p class="text-muted text-center">Nenhuma conta em atraso</p>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Top Categorias -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="bi bi-tags"></i> Categorias Mais Utilizadas
                </h6>
            </div>
            <div class="card-body">
                @forelse($top_categories ?? [] as $category)
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="d-flex align-items-center">
                            <span class="badge me-2" style="background-color: {{ $category->color }}"></span>
                            {{ $category->name }}
                        </div>
                        <span class="fw-bold">R$ {{ number_format($category->total ?? 0, 2, ',', '.') }}</span>
                    </div>
                @empty
                    <p class="text-muted text-center">Nenhuma categoria encontrada</p>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Gráfico de Fluxo de Caixa
const ctx = document.getElementById('cashFlowChart').getContext('2d');
const cashFlowChart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chart_labels ?? []) !!},
        datasets: [{
            label: 'Entradas',
            data: {!! json_encode($chart_income ?? []) !!},
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }, {
            label: 'Saídas',
            data: {!! json_encode($chart_expenses ?? []) !!},
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        plugins: {
            title: {
                display: true,
                text: 'Fluxo de Caixa Mensal'
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'R$ ' + value.toLocaleString('pt-BR');
                    }
                }
            }
        }
    }
});
</script>
@endpush
