@extends('layouts.app')

@section('title', 'Relatório de Veículos - Sistema de Gestão')
@section('page-title', 'Relatório de Veículos')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0">Relatório de Veículos</h4>
        <p class="text-muted">Análise completa do seu estoque</p>
    </div>
    <div class="btn-group">
        <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
            <i class="bi bi-download"></i> Exportar
        </button>
        <ul class="dropdown-menu">
            <li>
                <form method="POST" action="{{ route('reports.cars.export') }}" style="display: inline;">
                    @csrf
                    <input type="hidden" name="format" value="excel">
                    <button type="submit" class="dropdown-item">
                        <i class="bi bi-file-earmark-excel"></i> Excel
                    </button>
                </form>
            </li>
            <li>
                <form method="POST" action="{{ route('reports.cars.export') }}" style="display: inline;">
                    @csrf
                    <input type="hidden" name="format" value="pdf">
                    <button type="submit" class="dropdown-item">
                        <i class="bi bi-file-earmark-pdf"></i> PDF
                    </button>
                </form>
            </li>
        </ul>
    </div>
</div>

<!-- Resumo Geral -->
<div class="row mb-4">
    <div class="col-md-2">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h4>{{ $summary['total_cars'] }}</h4>
                <small>Total de Veículos</small>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="card bg-info text-white">
            <div class="card-body text-center">
                <h4>{{ $summary['cars_sold'] }}</h4>
                <small>Vendidos</small>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="card bg-warning text-white">
            <div class="card-body text-center">
                <h6>R$ {{ number_format($summary['total_invested'], 0, ',', '.') }}</h6>
                <small>Investido</small>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="card bg-secondary text-white">
            <div class="card-body text-center">
                <h6>R$ {{ number_format($summary['total_expenses'], 0, ',', '.') }}</h6>
                <small>Despesas</small>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h6>R$ {{ number_format($summary['total_profit'], 0, ',', '.') }}</h6>
                <small>Lucros</small>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h6>R$ {{ number_format($summary['total_loss'], 0, ',', '.') }}</h6>
                <small>Prejuízos</small>
            </div>
        </div>
    </div>
</div>

<!-- Lista Detalhada -->
<div class="card">
    <div class="card-header">
        <h6 class="mb-0">Detalhamento por Veículo</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Veículo</th>
                        <th>Ano</th>
                        <th>Placa</th>
                        <th>Compra</th>
                        <th>Venda</th>
                        <th>Despesas</th>
                        <th>Resultado</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($cars as $car)
                        <tr>
                            <td>
                                <strong>{{ $car->brand }} {{ $car->model }}</strong>
                                @if($car->color)
                                    <br><small class="text-muted">{{ $car->color }}</small>
                                @endif
                            </td>
                            <td>{{ $car->year ?? '-' }}</td>
                            <td>{{ $car->plate ?? '-' }}</td>
                            <td>
                                @if($car->purchase_price)
                                    R$ {{ number_format($car->purchase_price, 2, ',', '.') }}
                                    @if($car->purchase_date)
                                        <br><small class="text-muted">{{ $car->purchase_date->format('d/m/Y') }}</small>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                @if($car->sale_price)
                                    R$ {{ number_format($car->sale_price, 2, ',', '.') }}
                                    @if($car->sale_date)
                                        <br><small class="text-muted">{{ $car->sale_date->format('d/m/Y') }}</small>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                            <td>R$ {{ number_format($car->total_expenses, 2, ',', '.') }}</td>
                            <td>
                                @if($car->profit_loss != 0)
                                    @if($car->profit_loss > 0)
                                        <span class="text-success fw-bold">
                                            +R$ {{ number_format($car->profit_loss, 2, ',', '.') }}
                                        </span>
                                    @else
                                        <span class="text-danger fw-bold">
                                            -R$ {{ number_format(abs($car->profit_loss), 2, ',', '.') }}
                                        </span>
                                    @endif
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @switch($car->status)
                                    @case('owned')
                                        <span class="badge bg-success">Em Estoque</span>
                                        @break
                                    @case('sold')
                                        <span class="badge bg-info">Vendido</span>
                                        @break
                                    @case('maintenance')
                                        <span class="badge bg-warning">Manutenção</span>
                                        @break
                                @endswitch
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
