@extends('layouts.app')

@section('title', 'Relatório Financeiro - Sistema de Gestão')
@section('page-title', 'Relatório Financeiro')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-0">Relatório Financeiro</h4>
        <p class="text-muted">Período: {{ $dateFrom->format('d/m/Y') }} a {{ $dateTo->format('d/m/Y') }}</p>
    </div>
    <div class="btn-group">
        <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
            <i class="bi bi-download"></i> Exportar
        </button>
        <ul class="dropdown-menu">
            <li>
                <form method="POST" action="{{ route('reports.financial.export') }}" style="display: inline;">
                    @csrf
                    <input type="hidden" name="format" value="excel">
                    <input type="hidden" name="date_from" value="{{ $dateFrom->format('Y-m-d') }}">
                    <input type="hidden" name="date_to" value="{{ $dateTo->format('Y-m-d') }}">
                    <button type="submit" class="dropdown-item">
                        <i class="bi bi-file-earmark-excel"></i> Excel
                    </button>
                </form>
            </li>
            <li>
                <form method="POST" action="{{ route('reports.financial.export') }}" style="display: inline;">
                    @csrf
                    <input type="hidden" name="format" value="pdf">
                    <input type="hidden" name="date_from" value="{{ $dateFrom->format('Y-m-d') }}">
                    <input type="hidden" name="date_to" value="{{ $dateTo->format('Y-m-d') }}">
                    <button type="submit" class="dropdown-item">
                        <i class="bi bi-file-earmark-pdf"></i> PDF
                    </button>
                </form>
            </li>
        </ul>
    </div>
</div>

<!-- Filtros de Período -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Data Inicial</label>
                <input type="date" class="form-control" name="date_from" 
                       value="{{ request('date_from', $dateFrom->format('Y-m-d')) }}">
            </div>
            <div class="col-md-4">
                <label class="form-label">Data Final</label>
                <input type="date" class="form-control" name="date_to" 
                       value="{{ request('date_to', $dateTo->format('Y-m-d')) }}">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search"></i> Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Resumo -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <h6 class="card-title">Total a Pagar</h6>
                <h4>R$ {{ number_format($summary['total_payable'], 2, ',', '.') }}</h4>
                <small>Pago: R$ {{ number_format($summary['total_payable_paid'], 2, ',', '.') }}</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">Total a Receber</h6>
                <h4>R$ {{ number_format($summary['total_receivable'], 2, ',', '.') }}</h4>
                <small>Recebido: R$ {{ number_format($summary['total_receivable_received'], 2, ',', '.') }}</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card {{ $summary['balance'] >= 0 ? 'bg-info' : 'bg-warning' }} text-white">
            <div class="card-body">
                <h6 class="card-title">Saldo Realizado</h6>
                <h4>R$ {{ number_format(abs($summary['balance']), 2, ',', '.') }}</h4>
                <small>{{ $summary['balance'] >= 0 ? 'Positivo' : 'Negativo' }}</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Saldo Previsto</h6>
                @php
                    $expectedBalance = $summary['total_receivable'] - $summary['total_payable'];
                @endphp
                <h4>R$ {{ number_format(abs($expectedBalance), 2, ',', '.') }}</h4>
                <small>{{ $expectedBalance >= 0 ? 'Positivo' : 'Negativo' }}</small>
            </div>
        </div>
    </div>
</div>

<!-- Gráfico -->
<div class="card mb-4">
    <div class="card-header">
        <h6 class="mb-0">Fluxo de Caixa no Período</h6>
    </div>
    <div class="card-body">
        <canvas id="financialChart" height="100"></canvas>
    </div>
</div>

<div class="row">
    <!-- Contas a Pagar -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0 text-danger">
                    <i class="bi bi-credit-card"></i> Contas a Pagar ({{ $accountsPayable->count() }})
                </h6>
            </div>
            <div class="card-body">
                @if($accountsPayable->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Vencimento</th>
                                    <th>Descrição</th>
                                    <th>Valor</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($accountsPayable as $account)
                                    <tr class="{{ $account->status === 'pending' && $account->due_date < now() ? 'table-danger' : '' }}">
                                        <td>{{ $account->due_date->format('d/m/Y') }}</td>
                                        <td>
                                            {{ $account->description }}
                                            @if($account->supplier)
                                                <br><small class="text-muted">{{ $account->supplier->name }}</small>
                                            @endif
                                        </td>
                                        <td>R$ {{ number_format($account->amount, 2, ',', '.') }}</td>
                                        <td>
                                            @switch($account->status)
                                                @case('pending')
                                                    <span class="badge bg-warning">Pendente</span>
                                                    @break
                                                @case('paid')
                                                    <span class="badge bg-success">Pago</span>
                                                    @break
                                                @case('overdue')
                                                    <span class="badge bg-danger">Atrasado</span>
                                                    @break
                                            @endswitch
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted text-center">Nenhuma conta a pagar no período</p>
                @endif
            </div>
        </div>
    </div>

    <!-- Contas a Receber -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0 text-success">
                    <i class="bi bi-cash-coin"></i> Contas a Receber ({{ $accountsReceivable->count() }})
                </h6>
            </div>
            <div class="card-body">
                @if($accountsReceivable->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Vencimento</th>
                                    <th>Descrição</th>
                                    <th>Valor</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($accountsReceivable as $account)
                                    <tr class="{{ $account->status === 'pending' && $account->due_date < now() ? 'table-danger' : '' }}">
                                        <td>{{ $account->due_date->format('d/m/Y') }}</td>
                                        <td>
                                            {{ $account->description }}
                                            @if($account->customer)
                                                <br><small class="text-muted">{{ $account->customer->name }}</small>
                                            @endif
                                        </td>
                                        <td>R$ {{ number_format($account->amount, 2, ',', '.') }}</td>
                                        <td>
                                            @switch($account->status)
                                                @case('pending')
                                                    <span class="badge bg-warning">Pendente</span>
                                                    @break
                                                @case('received')
                                                    <span class="badge bg-success">Recebido</span>
                                                    @break
                                                @case('overdue')
                                                    <span class="badge bg-danger">Atrasado</span>
                                                    @break
                                            @endswitch
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted text-center">Nenhuma conta a receber no período</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
const ctx = document.getElementById('financialChart').getContext('2d');
const chart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['days']) !!},
        datasets: [{
            label: 'Entradas',
            data: {!! json_encode($chartData['income']) !!},
            borderColor: 'rgb(34, 197, 94)',
            backgroundColor: 'rgba(34, 197, 94, 0.1)',
            tension: 0.1
        }, {
            label: 'Saídas',
            data: {!! json_encode($chartData['expenses']) !!},
            borderColor: 'rgb(239, 68, 68)',
            backgroundColor: 'rgba(239, 68, 68, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        plugins: {
            title: {
                display: true,
                text: 'Fluxo de Caixa Diário'
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'R$ ' + value.toLocaleString('pt-BR');
                    }
                }
            }
        }
    }
});
</script>
@endpush
