<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Relatório Financeiro</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .company-name {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .report-title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .period {
            font-size: 12px;
            color: #666;
        }
        .summary {
            margin: 20px 0;
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
        }
        .summary-item {
            display: inline-block;
            width: 48%;
            margin-bottom: 10px;
        }
        .summary-label {
            font-weight: bold;
        }
        .summary-value {
            color: #007bff;
            font-weight: bold;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            margin: 25px 0 10px 0;
            padding: 5px 0;
            border-bottom: 1px solid #ddd;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-pending {
            color: #ffc107;
            font-weight: bold;
        }
        .status-paid {
            color: #28a745;
            font-weight: bold;
        }
        .status-received {
            color: #28a745;
            font-weight: bold;
        }
        .overdue {
            background-color: #ffe6e6;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">{{ $company->name }}</div>
        <div class="report-title">RELATÓRIO FINANCEIRO</div>
        <div class="period">Período: {{ $dateFrom->format('d/m/Y') }} a {{ $dateTo->format('d/m/Y') }}</div>
    </div>

    <div class="summary">
        <div class="summary-item">
            <span class="summary-label">Total a Pagar:</span>
            <span class="summary-value">R$ {{ number_format($summary['total_payable'], 2, ',', '.') }}</span>
        </div>
        <div class="summary-item">
            <span class="summary-label">Total a Receber:</span>
            <span class="summary-value">R$ {{ number_format($summary['total_receivable'], 2, ',', '.') }}</span>
        </div>
        <div class="summary-item">
            <span class="summary-label">Saldo:</span>
            <span class="summary-value">R$ {{ number_format($summary['balance'], 2, ',', '.') }}</span>
        </div>
    </div>

    <div class="section-title">CONTAS A PAGAR</div>
    @if($accountsPayable->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Data Venc.</th>
                    <th>Descrição</th>
                    <th>Fornecedor</th>
                    <th class="text-right">Valor</th>
                    <th class="text-center">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($accountsPayable as $account)
                    <tr class="{{ $account->status === 'pending' && $account->due_date < now() ? 'overdue' : '' }}">
                        <td>{{ $account->due_date->format('d/m/Y') }}</td>
                        <td>{{ $account->description }}</td>
                        <td>{{ $account->supplier->name ?? '-' }}</td>
                        <td class="text-right">R$ {{ number_format($account->amount, 2, ',', '.') }}</td>
                        <td class="text-center">
                            @switch($account->status)
                                @case('pending')
                                    <span class="status-pending">Pendente</span>
                                    @break
                                @case('paid')
                                    <span class="status-paid">Pago</span>
                                    @break
                                @default
                                    {{ ucfirst($account->status) }}
                            @endswitch
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>Nenhuma conta a pagar no período.</p>
    @endif

    <div class="section-title">CONTAS A RECEBER</div>
    @if($accountsReceivable->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Data Venc.</th>
                    <th>Descrição</th>
                    <th>Cliente</th>
                    <th class="text-right">Valor</th>
                    <th class="text-center">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($accountsReceivable as $account)
                    <tr class="{{ $account->status === 'pending' && $account->due_date < now() ? 'overdue' : '' }}">
                        <td>{{ $account->due_date->format('d/m/Y') }}</td>
                        <td>{{ $account->description }}</td>
                        <td>{{ $account->customer->name ?? '-' }}</td>
                        <td class="text-right">R$ {{ number_format($account->amount, 2, ',', '.') }}</td>
                        <td class="text-center">
                            @switch($account->status)
                                @case('pending')
                                    <span class="status-pending">Pendente</span>
                                    @break
                                @case('received')
                                    <span class="status-received">Recebido</span>
                                    @break
                                @default
                                    {{ ucfirst($account->status) }}
                            @endswitch
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>Nenhuma conta a receber no período.</p>
    @endif

    <div class="footer">
        Relatório gerado em {{ now()->format('d/m/Y H:i:s') }} - Sistema de Gestão Financeira
    </div>
</body>
</html>
