@extends('layouts.app')

@section('title', 'Agenda')
@section('page-title', 'Agenda')

@section('content')
<div class="row mb-4">
    <!-- Estatísticas -->
    <div class="col-md-3">
        <div class="card stats-card">
            <div class="card-body text-center">
                <i class="bi bi-calendar-event fs-1"></i>
                <h3 class="mt-2">{{ $statistics['total'] }}</h3>
                <p class="mb-0">Total de Eventos</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body text-center">
                <i class="bi bi-clock fs-1"></i>
                <h3 class="mt-2">{{ $statistics['pending'] }}</h3>
                <p class="mb-0">Pendentes</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <i class="bi bi-exclamation-triangle fs-1"></i>
                <h3 class="mt-2">{{ $statistics['overdue'] }}</h3>
                <p class="mb-0">Em Atraso</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <i class="bi bi-check-circle fs-1"></i>
                <h3 class="mt-2">{{ $statistics['completed'] }}</h3>
                <p class="mb-0">Concluídos</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <!-- Lista de Eventos -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-list-ul"></i> Lista de Eventos
                </h5>
                <div>
                    <a href="{{ route('schedules.calendar') }}" class="btn btn-outline-primary btn-sm">
                        <i class="bi bi-calendar3"></i> Calendário
                    </a>
                    <a href="{{ route('schedules.create') }}" class="btn btn-primary btn-sm">
                        <i class="bi bi-plus"></i> Novo Evento
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Filtros -->
                <form method="GET" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <select name="type" class="form-select">
                            <option value="">Todos os Tipos</option>
                            <option value="appointment" {{ request('type') == 'appointment' ? 'selected' : '' }}>Compromisso</option>
                            <option value="reminder" {{ request('type') == 'reminder' ? 'selected' : '' }}>Lembrete</option>
                            <option value="task" {{ request('type') == 'task' ? 'selected' : '' }}>Tarefa</option>
                            <option value="meeting" {{ request('type') == 'meeting' ? 'selected' : '' }}>Reunião</option>
                            <option value="deadline" {{ request('type') == 'deadline' ? 'selected' : '' }}>Prazo</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="status" class="form-select">
                            <option value="">Todos Status</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pendente</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Concluído</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelado</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select name="priority" class="form-select">
                            <option value="">Todas Prioridades</option>
                            <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Baixa</option>
                            <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>Média</option>
                            <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>Alta</option>
                            <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>Urgente</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}" placeholder="Data Inicial">
                    </div>
                    <div class="col-md-2">
                        <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}" placeholder="Data Final">
                    </div>
                    <div class="col-md-1">
                        <button type="submit" class="btn btn-outline-primary">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                </form>

                <!-- Lista -->
                @if($schedules->count() > 0)
                    <div class="list-group">
                        @foreach($schedules as $schedule)
                            <div class="list-group-item {{ $schedule->is_overdue ? 'border-danger' : '' }}">
                                <div class="d-flex w-100 justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <div class="d-flex align-items-center mb-2">
                                            <div class="me-3" style="width: 4px; height: 40px; background-color: {{ $schedule->color }}; border-radius: 2px;"></div>
                                            <div>
                                                <h6 class="mb-1">
                                                    <i class="{{ $schedule->type_icon }}"></i>
                                                    {{ $schedule->title }}
                                                    @if($schedule->is_overdue)
                                                        <span class="badge bg-danger ms-2">Em Atraso</span>
                                                    @endif
                                                </h6>
                                                <p class="mb-1 text-muted">{{ $schedule->description }}</p>
                                                <small class="text-muted">
                                                    <i class="bi bi-calendar"></i> {{ $schedule->formatted_date }}
                                                    @if($schedule->location)
                                                        | <i class="bi bi-geo-alt"></i> {{ $schedule->location }}
                                                    @endif
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge {{ $schedule->priority_badge }} mb-2">{{ $schedule->priority_label }}</span>
                                        <span class="badge bg-secondary">{{ $schedule->type_label }}</span>
                                        <div class="btn-group mt-2" role="group">
                                            <a href="{{ route('schedules.show', $schedule) }}" class="btn btn-outline-primary btn-sm">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            @if($schedule->status === 'pending')
                                                <button type="button" class="btn btn-outline-success btn-sm" onclick="completeSchedule({{ $schedule->id }})">
                                                    <i class="bi bi-check"></i>
                                                </button>
                                            @endif
                                            <a href="{{ route('schedules.edit', $schedule) }}" class="btn btn-outline-warning btn-sm">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Paginação -->
                    <div class="mt-4">
                        {{ $schedules->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="bi bi-calendar-x fs-1 text-muted"></i>
                        <h5 class="mt-3 text-muted">Nenhum evento encontrado</h5>
                        <p class="text-muted">Crie seu primeiro evento para começar a organizar sua agenda.</p>
                        <a href="{{ route('schedules.create') }}" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Criar Evento
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <!-- Próximos Eventos -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="bi bi-clock"></i> Próximos Eventos
                </h6>
            </div>
            <div class="card-body">
                @if($upcoming->count() > 0)
                    @foreach($upcoming as $event)
                        <div class="d-flex align-items-center mb-3">
                            <div class="me-3" style="width: 3px; height: 30px; background-color: {{ $event->color }}; border-radius: 2px;"></div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">{{ $event->title }}</h6>
                                <small class="text-muted">{{ $event->formatted_date }}</small>
                            </div>
                            <span class="badge {{ $event->priority_badge }}">{{ $event->priority_label }}</span>
                        </div>
                    @endforeach
                    <a href="{{ route('schedules.upcoming') }}" class="btn btn-outline-primary btn-sm w-100">
                        Ver Todos
                    </a>
                @else
                    <p class="text-muted text-center">Nenhum evento próximo</p>
                @endif
            </div>
        </div>

        <!-- Eventos em Atraso -->
        @if($overdue->count() > 0)
            <div class="card">
                <div class="card-header bg-danger text-white">
                    <h6 class="mb-0">
                        <i class="bi bi-exclamation-triangle"></i> Em Atraso
                    </h6>
                </div>
                <div class="card-body">
                    @foreach($overdue as $event)
                        <div class="d-flex align-items-center mb-3">
                            <div class="me-3" style="width: 3px; height: 30px; background-color: #dc3545; border-radius: 2px;"></div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">{{ $event->title }}</h6>
                                <small class="text-muted">{{ $event->formatted_date }}</small>
                            </div>
                            <button type="button" class="btn btn-outline-success btn-sm" onclick="completeSchedule({{ $event->id }})">
                                <i class="bi bi-check"></i>
                            </button>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function completeSchedule(scheduleId) {
    if (confirm('Marcar este evento como concluído?')) {
        fetch(`/schedules/${scheduleId}/complete`, {
            method: 'PATCH',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao marcar evento como concluído');
        });
    }
}
</script>
@endpush
