@extends('layouts.app')

@section('title', 'Agenda de Hoje')
@section('page-title', 'Agenda de Hoje')

@section('content')
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card stats-card">
            <div class="card-body text-center">
                <i class="bi bi-calendar-day fs-1"></i>
                <h2 class="mt-2">{{ now()->format('d/m/Y') }}</h2>
                <p class="mb-0">{{ now()->translatedFormat('l') }} - {{ $schedules->count() }} evento(s) hoje</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-list-ul"></i> Eventos de Hoje
                </h5>
                <div>
                    <a href="{{ route('schedules.calendar') }}" class="btn btn-outline-primary btn-sm">
                        <i class="bi bi-calendar3"></i> Calendário
                    </a>
                    <a href="{{ route('schedules.create') }}?date={{ now()->format('Y-m-d') }}" class="btn btn-primary btn-sm">
                        <i class="bi bi-plus"></i> Novo Evento
                    </a>
                </div>
            </div>
            <div class="card-body">
                @if($schedules->count() > 0)
                    <div class="timeline">
                        @foreach($schedules->sortBy('scheduled_at') as $schedule)
                            <div class="timeline-item mb-4">
                                <div class="d-flex">
                                    <div class="timeline-marker me-3">
                                        <div class="timeline-time">
                                            @if($schedule->all_day)
                                                <small class="text-muted">Dia todo</small>
                                            @else
                                                <small class="text-muted">{{ $schedule->scheduled_at->format('H:i') }}</small>
                                            @endif
                                        </div>
                                        <div class="timeline-dot" style="background-color: {{ $schedule->color }};"></div>
                                    </div>
                                    <div class="timeline-content flex-grow-1">
                                        <div class="card {{ $schedule->is_overdue ? 'border-danger' : '' }}">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-start">
                                                    <div class="flex-grow-1">
                                                        <h6 class="card-title mb-1">
                                                            <i class="{{ $schedule->type_icon }}"></i>
                                                            {{ $schedule->title }}
                                                            @if($schedule->is_overdue)
                                                                <span class="badge bg-danger ms-2">Em Atraso</span>
                                                            @endif
                                                        </h6>
                                                        @if($schedule->description)
                                                            <p class="card-text text-muted mb-2">{{ $schedule->description }}</p>
                                                        @endif
                                                        <div class="d-flex gap-2 mb-2">
                                                            <span class="badge {{ $schedule->priority_badge }}">{{ $schedule->priority_label }}</span>
                                                            <span class="badge bg-secondary">{{ $schedule->type_label }}</span>
                                                            @if($schedule->status === 'completed')
                                                                <span class="badge bg-success">Concluído</span>
                                                            @endif
                                                        </div>
                                                        @if($schedule->location)
                                                            <small class="text-muted">
                                                                <i class="bi bi-geo-alt"></i> {{ $schedule->location }}
                                                            </small>
                                                        @endif
                                                    </div>
                                                    <div class="text-end">
                                                        <div class="btn-group" role="group">
                                                            @if($schedule->status === 'pending')
                                                                <button type="button" class="btn btn-outline-success btn-sm" onclick="completeSchedule({{ $schedule->id }})">
                                                                    <i class="bi bi-check"></i>
                                                                </button>
                                                            @endif
                                                            <a href="{{ route('schedules.show', $schedule) }}" class="btn btn-outline-primary btn-sm">
                                                                <i class="bi bi-eye"></i>
                                                            </a>
                                                            <a href="{{ route('schedules.edit', $schedule) }}" class="btn btn-outline-warning btn-sm">
                                                                <i class="bi bi-pencil"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="bi bi-calendar-x fs-1 text-muted"></i>
                        <h5 class="mt-3 text-muted">Nenhum evento hoje</h5>
                        <p class="text-muted">Que tal aproveitar o dia livre ou criar um novo evento?</p>
                        <a href="{{ route('schedules.create') }}?date={{ now()->format('Y-m-d') }}" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Criar Evento para Hoje
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <!-- Resumo do Dia -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="bi bi-pie-chart"></i> Resumo do Dia
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <h4 class="text-primary">{{ $schedules->where('status', 'pending')->count() }}</h4>
                        <small class="text-muted">Pendentes</small>
                    </div>
                    <div class="col-6">
                        <h4 class="text-success">{{ $schedules->where('status', 'completed')->count() }}</h4>
                        <small class="text-muted">Concluídos</small>
                    </div>
                </div>
                <hr>
                <div class="row text-center">
                    <div class="col-6">
                        <h4 class="text-warning">{{ $schedules->where('priority', 'high')->count() + $schedules->where('priority', 'urgent')->count() }}</h4>
                        <small class="text-muted">Alta Prioridade</small>
                    </div>
                    <div class="col-6">
                        <h4 class="text-danger">{{ $schedules->where('is_overdue', true)->count() }}</h4>
                        <small class="text-muted">Em Atraso</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Próximos Dias -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="bi bi-calendar-week"></i> Próximos Dias
                </h6>
            </div>
            <div class="card-body">
                @php
                    $nextDays = collect();
                    for($i = 1; $i <= 7; $i++) {
                        $date = now()->addDays($i);
                        $count = \App\Models\Schedule::forUser(auth()->id())
                            ->whereDate('scheduled_at', $date)
                            ->count();
                        if($count > 0) {
                            $nextDays->push(['date' => $date, 'count' => $count]);
                        }
                    }
                @endphp

                @if($nextDays->count() > 0)
                    @foreach($nextDays->take(5) as $day)
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                <strong>{{ $day['date']->format('d/m') }}</strong>
                                <small class="text-muted d-block">{{ $day['date']->translatedFormat('D') }}</small>
                            </div>
                            <span class="badge bg-primary">{{ $day['count'] }} evento(s)</span>
                        </div>
                    @endforeach
                @else
                    <p class="text-muted text-center">Nenhum evento nos próximos dias</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.timeline {
    position: relative;
}

.timeline-item {
    position: relative;
}

.timeline-marker {
    display: flex;
    flex-direction: column;
    align-items: center;
    width: 80px;
}

.timeline-time {
    margin-bottom: 8px;
    font-weight: 500;
}

.timeline-dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    position: relative;
    z-index: 1;
}

.timeline-content {
    position: relative;
}

.timeline-item:not(:last-child) .timeline-marker::after {
    content: '';
    position: absolute;
    top: 20px;
    left: 50%;
    transform: translateX(-50%);
    width: 2px;
    height: calc(100% + 20px);
    background-color: #e9ecef;
    z-index: 0;
}
</style>
@endpush

@push('scripts')
<script>
function completeSchedule(scheduleId) {
    if (confirm('Marcar este evento como concluído?')) {
        fetch(`/schedules/${scheduleId}/complete`, {
            method: 'PATCH',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao marcar evento como concluído');
        });
    }
}
</script>
@endpush
