@extends('layouts.app')

@section('title', 'Configurações - Sistema de Gestão')
@section('page-title', 'Configurações')

@section('content')
<div class="row">
    <div class="col-lg-3">
        <!-- Menu de Navegação -->
        <div class="card">
            <div class="card-body">
                <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist">
                    <button class="nav-link active" id="general-tab" data-bs-toggle="pill" 
                            data-bs-target="#general" type="button" role="tab">
                        <i class="bi bi-gear"></i> Geral
                    </button>
                    <button class="nav-link" id="financial-tab" data-bs-toggle="pill" 
                            data-bs-target="#financial" type="button" role="tab">
                        <i class="bi bi-cash-coin"></i> Financeiro
                    </button>
                    <button class="nav-link" id="notifications-tab" data-bs-toggle="pill" 
                            data-bs-target="#notifications" type="button" role="tab">
                        <i class="bi bi-bell"></i> Notificações
                    </button>
                    <button class="nav-link" id="reports-tab" data-bs-toggle="pill" 
                            data-bs-target="#reports" type="button" role="tab">
                        <i class="bi bi-file-text"></i> Relatórios
                    </button>
                    <button class="nav-link" id="backup-tab" data-bs-toggle="pill" 
                            data-bs-target="#backup" type="button" role="tab">
                        <i class="bi bi-shield-check"></i> Backup
                    </button>
                    <button class="nav-link" id="system-tab" data-bs-toggle="pill" 
                            data-bs-target="#system" type="button" role="tab">
                        <i class="bi bi-cpu"></i> Sistema
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-9">
        <form method="POST" action="{{ route('settings.update') }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div class="tab-content" id="v-pills-tabContent">
                <!-- Configurações Gerais -->
                <div class="tab-pane fade show active" id="general" role="tabpanel">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="bi bi-gear"></i> Configurações Gerais
                            </h5>
                        </div>
                        <div class="card-body">
                            @if(isset($settings['general']))
                                @foreach($settings['general'] as $setting)
                                    <div class="mb-3">
                                        <label class="form-label">{{ $setting['label'] }}</label>
                                        
                                        @if($setting['type'] === 'boolean')
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" 
                                                       name="settings[{{ $setting['key'] }}]" 
                                                       id="{{ $setting['key'] }}"
                                                       {{ $setting['value'] ? 'checked' : '' }}>
                                                <label class="form-check-label" for="{{ $setting['key'] }}">
                                                    {{ $setting['description'] ?? 'Ativar esta opção' }}
                                                </label>
                                            </div>
                                        @elseif($setting['options'])
                                            <select class="form-select" name="settings[{{ $setting['key'] }}]">
                                                @foreach($setting['options'] as $value => $label)
                                                    <option value="{{ $value }}" 
                                                            {{ $setting['value'] == $value ? 'selected' : '' }}>
                                                        {{ $label }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        @elseif($setting['key'] === 'company_logo')
                                            @if($setting['value'])
                                                <div class="mb-2">
                                                    <img src="{{ Storage::url($setting['value']) }}" 
                                                         alt="Logo atual" class="img-thumbnail" style="max-height: 100px;">
                                                </div>
                                            @endif
                                            <input type="file" class="form-control" name="company_logo" 
                                                   accept="image/*">
                                        @else
                                            <input type="{{ $setting['type'] === 'integer' ? 'number' : 'text' }}" 
                                                   class="form-control" 
                                                   name="settings[{{ $setting['key'] }}]" 
                                                   value="{{ $setting['value'] }}">
                                        @endif
                                        
                                        @if($setting['description'] && $setting['type'] !== 'boolean')
                                            <div class="form-text">{{ $setting['description'] }}</div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Configurações Financeiras -->
                <div class="tab-pane fade" id="financial" role="tabpanel">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="bi bi-cash-coin"></i> Configurações Financeiras
                            </h5>
                        </div>
                        <div class="card-body">
                            @if(isset($settings['financial']))
                                @foreach($settings['financial'] as $setting)
                                    <div class="mb-3">
                                        <label class="form-label">{{ $setting['label'] }}</label>
                                        
                                        @if($setting['type'] === 'boolean')
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" 
                                                       name="settings[{{ $setting['key'] }}]" 
                                                       id="{{ $setting['key'] }}"
                                                       {{ $setting['value'] ? 'checked' : '' }}>
                                                <label class="form-check-label" for="{{ $setting['key'] }}">
                                                    {{ $setting['description'] ?? 'Ativar esta opção' }}
                                                </label>
                                            </div>
                                        @else
                                            <input type="{{ $setting['type'] === 'integer' ? 'number' : 'text' }}" 
                                                   class="form-control" 
                                                   name="settings[{{ $setting['key'] }}]" 
                                                   value="{{ $setting['value'] }}"
                                                   step="{{ $setting['type'] === 'string' && strpos($setting['key'], 'rate') !== false ? '0.01' : '1' }}">
                                        @endif
                                        
                                        @if($setting['description'] && $setting['type'] !== 'boolean')
                                            <div class="form-text">{{ $setting['description'] }}</div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Configurações de Notificações -->
                <div class="tab-pane fade" id="notifications" role="tabpanel">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="bi bi-bell"></i> Notificações
                            </h5>
                            <div class="btn-group btn-group-sm">
                                <button type="button" class="btn btn-outline-primary" onclick="testNotifications()">
                                    <i class="bi bi-bell"></i> Testar
                                </button>
                                <button type="button" class="btn btn-outline-success" onclick="runChecks()">
                                    <i class="bi bi-play"></i> Executar Verificações
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            @if(isset($settings['notifications']))
                                @foreach($settings['notifications'] as $setting)
                                    <div class="mb-3">
                                        <label class="form-label">{{ $setting['label'] }}</label>
                                        
                                        @if($setting['type'] === 'boolean')
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" 
                                                       name="settings[{{ $setting['key'] }}]" 
                                                       id="{{ $setting['key'] }}"
                                                       {{ $setting['value'] ? 'checked' : '' }}>
                                                <label class="form-check-label" for="{{ $setting['key'] }}">
                                                    {{ $setting['description'] ?? 'Ativar esta opção' }}
                                                </label>
                                            </div>
                                        @else
                                            <input type="{{ $setting['type'] === 'integer' ? 'number' : ($setting['key'] === 'notification_email' ? 'email' : 'text') }}" 
                                                   class="form-control" 
                                                   name="settings[{{ $setting['key'] }}]" 
                                                   value="{{ $setting['value'] }}">
                                        @endif
                                        
                                        @if($setting['description'] && $setting['type'] !== 'boolean')
                                            <div class="form-text">{{ $setting['description'] }}</div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Configurações de Relatórios -->
                <div class="tab-pane fade" id="reports" role="tabpanel">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="bi bi-file-text"></i> Relatórios
                            </h5>
                        </div>
                        <div class="card-body">
                            @if(isset($settings['reports']))
                                @foreach($settings['reports'] as $setting)
                                    <div class="mb-3">
                                        <label class="form-label">{{ $setting['label'] }}</label>
                                        
                                        @if($setting['type'] === 'boolean')
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" 
                                                       name="settings[{{ $setting['key'] }}]" 
                                                       id="{{ $setting['key'] }}"
                                                       {{ $setting['value'] ? 'checked' : '' }}>
                                                <label class="form-check-label" for="{{ $setting['key'] }}">
                                                    {{ $setting['description'] ?? 'Ativar esta opção' }}
                                                </label>
                                            </div>
                                        @elseif($setting['options'])
                                            <select class="form-select" name="settings[{{ $setting['key'] }}]">
                                                @foreach($setting['options'] as $value => $label)
                                                    <option value="{{ $value }}" 
                                                            {{ $setting['value'] == $value ? 'selected' : '' }}>
                                                        {{ $label }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        @else
                                            <input type="text" class="form-control" 
                                                   name="settings[{{ $setting['key'] }}]" 
                                                   value="{{ $setting['value'] }}">
                                        @endif
                                        
                                        @if($setting['description'] && $setting['type'] !== 'boolean')
                                            <div class="form-text">{{ $setting['description'] }}</div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Configurações de Backup -->
                <div class="tab-pane fade" id="backup" role="tabpanel">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="bi bi-shield-check"></i> Backup e Segurança
                            </h5>
                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="createBackup()">
                                <i class="bi bi-download"></i> Backup Manual
                            </button>
                        </div>
                        <div class="card-body">
                            @if(isset($settings['backup']))
                                @foreach($settings['backup'] as $setting)
                                    <div class="mb-3">
                                        <label class="form-label">{{ $setting['label'] }}</label>
                                        
                                        @if($setting['type'] === 'boolean')
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" 
                                                       name="settings[{{ $setting['key'] }}]" 
                                                       id="{{ $setting['key'] }}"
                                                       {{ $setting['value'] ? 'checked' : '' }}>
                                                <label class="form-check-label" for="{{ $setting['key'] }}">
                                                    {{ $setting['description'] ?? 'Ativar esta opção' }}
                                                </label>
                                            </div>
                                        @elseif($setting['options'])
                                            <select class="form-select" name="settings[{{ $setting['key'] }}]">
                                                @foreach($setting['options'] as $value => $label)
                                                    <option value="{{ $value }}" 
                                                            {{ $setting['value'] == $value ? 'selected' : '' }}>
                                                        {{ $label }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        @else
                                            <input type="{{ $setting['type'] === 'integer' ? 'number' : 'text' }}" 
                                                   class="form-control" 
                                                   name="settings[{{ $setting['key'] }}]" 
                                                   value="{{ $setting['value'] }}">
                                        @endif
                                        
                                        @if($setting['description'] && $setting['type'] !== 'boolean')
                                            <div class="form-text">{{ $setting['description'] }}</div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif

                            <div class="alert alert-info">
                                <h6><i class="bi bi-info-circle"></i> Informações sobre Backup:</h6>
                                <ul class="mb-0">
                                    <li>Backups automáticos são executados conforme a frequência configurada</li>
                                    <li>Backups incluem todos os dados da empresa (exceto arquivos de upload)</li>
                                    <li>Backups antigos são removidos automaticamente conforme retenção configurada</li>
                                    <li>Recomendamos manter backups em local seguro e externo</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Configurações do Sistema -->
                <div class="tab-pane fade" id="system" role="tabpanel">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="bi bi-cpu"></i> Sistema
                            </h5>
                            <button type="button" class="btn btn-outline-warning btn-sm" onclick="clearCache()">
                                <i class="bi bi-arrow-clockwise"></i> Limpar Cache
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Informações do Sistema</h6>
                                    <table class="table table-sm">
                                        <tr>
                                            <td><strong>Versão PHP:</strong></td>
                                            <td>{{ PHP_VERSION }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Versão Laravel:</strong></td>
                                            <td>{{ app()->version() }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Ambiente:</strong></td>
                                            <td>{{ app()->environment() }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Timezone:</strong></td>
                                            <td>{{ config('app.timezone') }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <h6>Estatísticas de Uso</h6>
                                    <table class="table table-sm">
                                        <tr>
                                            <td><strong>Total de Usuários:</strong></td>
                                            <td>{{ \App\Models\User::where('company_id', auth()->user()->company_id)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total de Clientes:</strong></td>
                                            <td>{{ \App\Models\Customer::where('company_id', auth()->user()->company_id)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total de Fornecedores:</strong></td>
                                            <td>{{ \App\Models\Supplier::where('company_id', auth()->user()->company_id)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total de Veículos:</strong></td>
                                            <td>{{ \App\Models\Car::where('company_id', auth()->user()->company_id)->count() }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="alert alert-warning mt-3">
                                <h6><i class="bi bi-exclamation-triangle"></i> Ações do Sistema:</h6>
                                <div class="d-flex gap-2 flex-wrap">
                                    <button type="button" class="btn btn-sm btn-outline-info" onclick="optimizeDatabase()">
                                        <i class="bi bi-speedometer2"></i> Otimizar Banco
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-warning" onclick="clearLogs()">
                                        <i class="bi bi-trash"></i> Limpar Logs
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-success" onclick="runMaintenance()">
                                        <i class="bi bi-tools"></i> Manutenção
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Botões de Ação -->
            <div class="d-flex justify-content-between mt-4">
                <a href="{{ route('dashboard') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar ao Dashboard
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle"></i> Salvar Configurações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
function testNotifications() {
    fetch('{{ route("settings.test-notifications") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Notificação de teste enviada!');
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao enviar notificação de teste');
    });
}

function runChecks() {
    fetch('{{ route("settings.run-checks") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Verificações executadas com sucesso!');
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao executar verificações');
    });
}

function createBackup() {
    if (confirm('Deseja criar um backup manual dos dados?')) {
        window.location.href = '{{ route("settings.backup") }}';
    }
}

function clearCache() {
    if (confirm('Deseja limpar o cache do sistema?')) {
        fetch('{{ route("settings.clear-cache") }}', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Cache limpo com sucesso!');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao limpar cache');
        });
    }
}

function optimizeDatabase() {
    if (confirm('Deseja otimizar o banco de dados? Esta operação pode demorar alguns minutos.')) {
        // Implementar otimização do banco
        alert('Funcionalidade em desenvolvimento');
    }
}

function clearLogs() {
    if (confirm('Deseja limpar os logs do sistema?')) {
        // Implementar limpeza de logs
        alert('Funcionalidade em desenvolvimento');
    }
}

function runMaintenance() {
    if (confirm('Deseja executar a manutenção do sistema?')) {
        // Implementar manutenção
        alert('Funcionalidade em desenvolvimento');
    }
}
</script>
@endpush
