<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\CarController;
use App\Http\Controllers\AccountPayableController;
use App\Http\Controllers\AccountReceivableController;
use App\Http\Controllers\CustomerEntryController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\BankReconciliationController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ScheduleController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return redirect()->route('dashboard');
});

Route::middleware(['auth', 'ensure.user.belongs.to.company'])->group(function () {
    
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Clientes
    Route::resource('customers', CustomerController::class);
    Route::get('customers/{customer}/entries', [CustomerEntryController::class, 'index'])->name('customers.entries');
    Route::post('customers/{customer}/entries', [CustomerEntryController::class, 'store'])->name('customers.entries.store');
    Route::put('customers/{customer}/entries/{entry}', [CustomerEntryController::class, 'update'])->name('customers.entries.update');
    Route::delete('customers/{customer}/entries/{entry}', [CustomerEntryController::class, 'destroy'])->name('customers.entries.destroy');
    
    // Fornecedores
    Route::resource('suppliers', SupplierController::class);
    
    // Categorias
    Route::resource('categories', CategoryController::class);
    Route::get('categories-library', [CategoryController::class, 'library'])->name('categories.library');
    Route::post('categories/import-from-library', [CategoryController::class, 'importFromLibrary'])->name('categories.import-from-library');
    
    // Contas Bancárias
    Route::resource('bank-accounts', BankAccountController::class);
    
    // Veículos
    Route::resource('cars', CarController::class);
    
    // Contas a Pagar
    Route::resource('accounts-payable', AccountPayableController::class);
    Route::patch('accounts-payable/{accountPayable}/pay', [AccountPayableController::class, 'markAsPaid'])->name('accounts-payable.pay');
    Route::patch('accounts-payable/{accountPayable}/cancel', [AccountPayableController::class, 'cancel'])->name('accounts-payable.cancel');
    
    // Contas a Receber
    Route::resource('accounts-receivable', AccountReceivableController::class);
    Route::patch('accounts-receivable/{accountReceivable}/receive', [AccountReceivableController::class, 'markAsReceived'])->name('accounts-receivable.receive');
    Route::patch('accounts-receivable/{accountReceivable}/cancel', [AccountReceivableController::class, 'cancel'])->name('accounts-receivable.cancel');
    
    // Relatórios
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('financial', [ReportController::class, 'financial'])->name('financial');
        Route::get('financial/pdf', [ReportController::class, 'financialPdf'])->name('financial.pdf');
        Route::get('cars', [ReportController::class, 'cars'])->name('cars');
        Route::get('cars/pdf', [ReportController::class, 'carsPdf'])->name('cars.pdf');
        Route::get('customers', [ReportController::class, 'customers'])->name('customers');
        Route::get('customers/pdf', [ReportController::class, 'customersPdf'])->name('customers.pdf');
        Route::get('cash-flow', [ReportController::class, 'cashFlow'])->name('cash-flow');
        Route::get('cash-flow/pdf', [ReportController::class, 'cashFlowPdf'])->name('cash-flow.pdf');
    });
    
    // Conciliação Bancária
    Route::prefix('bank-reconciliation')->name('bank-reconciliation.')->group(function () {
        Route::get('/', [BankReconciliationController::class, 'index'])->name('index');
        Route::post('import', [BankReconciliationController::class, 'import'])->name('import');
        Route::post('reconcile', [BankReconciliationController::class, 'reconcile'])->name('reconcile');
        Route::get('export', [BankReconciliationController::class, 'export'])->name('export');
    });
    
    // Configurações
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [SettingsController::class, 'index'])->name('index');
        Route::post('/', [SettingsController::class, 'update'])->name('update');
        Route::post('backup', [SettingsController::class, 'backup'])->name('backup');
        Route::get('export-data', [SettingsController::class, 'exportData'])->name('export-data');
    });
    
    // Notificações
    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [NotificationController::class, 'index'])->name('index');
        Route::patch('{notification}/read', [NotificationController::class, 'markAsRead'])->name('read');
        Route::delete('{notification}', [NotificationController::class, 'destroy'])->name('destroy');
        Route::post('mark-all-read', [NotificationController::class, 'markAllAsRead'])->name('mark-all-read');
        Route::delete('clear-all', [NotificationController::class, 'clearAll'])->name('clear-all');
    });
    
    // Agenda e Lembretes
    Route::prefix('schedules')->name('schedules.')->group(function () {
        Route::get('/', [ScheduleController::class, 'index'])->name('index');
        Route::get('create', [ScheduleController::class, 'create'])->name('create');
        Route::post('/', [ScheduleController::class, 'store'])->name('store');
        Route::get('{schedule}', [ScheduleController::class, 'show'])->name('show');
        Route::get('{schedule}/edit', [ScheduleController::class, 'edit'])->name('edit');
        Route::put('{schedule}', [ScheduleController::class, 'update'])->name('update');
        Route::delete('{schedule}', [ScheduleController::class, 'destroy'])->name('destroy');
        
        // Rotas específicas da agenda
        Route::get('calendar/view', [ScheduleController::class, 'calendar'])->name('calendar');
        Route::get('calendar/data', [ScheduleController::class, 'calendarData'])->name('calendar.data');
        Route::get('today/view', [ScheduleController::class, 'today'])->name('today');
        Route::get('upcoming/view', [ScheduleController::class, 'upcoming'])->name('upcoming');
        
        // Ações rápidas
        Route::patch('{schedule}/complete', [ScheduleController::class, 'complete'])->name('complete');
        Route::patch('{schedule}/cancel', [ScheduleController::class, 'cancel'])->name('cancel');
        Route::post('{schedule}/duplicate', [ScheduleController::class, 'duplicate'])->name('duplicate');
    });
});

// Rotas de autenticação (assumindo que você está usando Laravel Breeze ou similar)
require __DIR__.'/auth.php';
