export interface Company {
  id: string
  name: string
  cnpj?: string
  email?: string
  phone?: string
  address?: string
}

export interface Customer {
  id: string
  name: string
  email?: string
  phone?: string
  cpfCnpj?: string
  address?: string
  balance?: number
}

export interface Supplier {
  id: string
  name: string
  email?: string
  phone?: string
  cnpj?: string
  address?: string
}

export interface Car {
  id: string
  model: string
  brand: string
  year?: number
  plate?: string
  purchasePrice?: number
  purchaseDate?: Date
  salePrice?: number
  saleDate?: Date
  status: "OWNED" | "SOLD"
  totalExpenses?: number
  profit?: number
}

export interface BankAccount {
  id: string
  name: string
  bank: string
  agency?: string
  account?: string
  balance: number
}

export interface Category {
  id: string
  name: string
  type: "DEBIT" | "CREDIT"
  color?: string
}

export interface AccountPayable {
  id: string
  description: string
  amount: number
  dueDate: Date
  paidDate?: Date
  status: "PENDING" | "PAID" | "OVERDUE" | "CANCELLED"
  supplier?: Supplier
  category?: Category
}

export interface AccountReceivable {
  id: string
  description: string
  amount: number
  dueDate: Date
  receivedDate?: Date
  status: "PENDING" | "PAID" | "OVERDUE" | "CANCELLED"
  customer?: Customer
  category?: Category
}

export interface CustomerEntry {
  id: string
  description: string
  amount: number
  type: "DEBIT" | "CREDIT"
  date: Date
  customer: Customer
  category?: Category
}
