import { defineConfig } from "vite"
import laravel from "laravel-vite-plugin"

export default defineConfig({
  plugins: [
    laravel({
      input: ["resources/css/app.css", "resources/js/app.js"],
      refresh: true,
    }),
  ],
  resolve: {
    alias: {
      "~bootstrap": "node_modules/bootstrap",
      "~bootstrap-icons": "node_modules/bootstrap-icons",
    },
  },
  build: {
    rollupOptions: {
      output: {
        manualChunks: {
          vendor: ["bootstrap", "axios", "lodash"],
          charts: ["chart.js"],
        },
      },
    },
  },
})
